/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.APOptions;
import sun.security.krb5.internal.APReq;
import sun.security.krb5.internal.Authenticator;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.EncTicketPart;
import sun.security.krb5.internal.HostAddress;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.LocalSeqNumber;
import sun.security.krb5.internal.ReplayCache;
import sun.security.krb5.internal.SeqNumber;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;
import sun.security.util.DerValue;

public class KrbApReq {
    private byte[] obuf;
    private KerberosTime ctime;
    private int cusec;
    private Authenticator authenticator;
    private Credentials creds;
    private APReq apReqMessg;
    private static ReplayCache rcache = ReplayCache.getInstance();
    private static boolean DEBUG = Krb5.DEBUG;
    private static final char[] hexConst = "0123456789ABCDEF".toCharArray();

    public KrbApReq(Credentials credentials, boolean bl, boolean bl2, boolean bl3, Checksum checksum) throws Asn1Exception, KrbCryptoException, KrbException, IOException {
        APOptions aPOptions;
        APOptions aPOptions2 = aPOptions = bl ? new APOptions(2) : new APOptions();
        if (DEBUG) {
            System.out.println(">>> KrbApReq: APOptions are " + aPOptions);
        }
        EncryptionKey encryptionKey = bl2 ? new EncryptionKey(credentials.getSessionKey()) : null;
        LocalSeqNumber localSeqNumber = new LocalSeqNumber();
        this.init(aPOptions, credentials, checksum, encryptionKey, localSeqNumber, null, 11);
    }

    public KrbApReq(byte[] byArray, Krb5AcceptCredential krb5AcceptCredential, InetAddress inetAddress) throws KrbException, IOException {
        this.obuf = byArray;
        if (this.apReqMessg == null) {
            this.decode();
        }
        this.authenticate(krb5AcceptCredential, inetAddress);
    }

    KrbApReq(APOptions aPOptions, Ticket ticket, EncryptionKey encryptionKey, PrincipalName principalName, Checksum checksum, KerberosTime kerberosTime, EncryptionKey encryptionKey2, SeqNumber seqNumber, AuthorizationData authorizationData) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        this.init(aPOptions, ticket, encryptionKey, principalName, checksum, kerberosTime, encryptionKey2, seqNumber, authorizationData, 7);
    }

    private void init(APOptions aPOptions, Credentials credentials, Checksum checksum, EncryptionKey encryptionKey, SeqNumber seqNumber, AuthorizationData authorizationData, int n) throws KrbException, IOException {
        this.ctime = KerberosTime.now();
        this.init(aPOptions, credentials.ticket, credentials.key, credentials.client, checksum, this.ctime, encryptionKey, seqNumber, authorizationData, n);
    }

    private void init(APOptions aPOptions, Ticket ticket, EncryptionKey encryptionKey, PrincipalName principalName, Checksum checksum, KerberosTime kerberosTime, EncryptionKey encryptionKey2, SeqNumber seqNumber, AuthorizationData authorizationData, int n) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        this.createMessage(aPOptions, ticket, encryptionKey, principalName, checksum, kerberosTime, encryptionKey2, seqNumber, authorizationData, n);
        this.obuf = this.apReqMessg.asn1Encode();
    }

    void decode() throws KrbException, IOException {
        DerValue derValue = new DerValue(this.obuf);
        this.decode(derValue);
    }

    void decode(DerValue derValue) throws KrbException, IOException {
        this.apReqMessg = null;
        try {
            this.apReqMessg = new APReq(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            this.apReqMessg = null;
            KRBError kRBError = new KRBError(derValue);
            String string = kRBError.getErrorString();
            String string2 = string.charAt(string.length() - 1) == '\u0000' ? string.substring(0, string.length() - 1) : string;
            KrbException krbException = new KrbException(kRBError.getErrorCode(), string2);
            krbException.initCause(asn1Exception);
            throw krbException;
        }
    }

    private void authenticate(Krb5AcceptCredential krb5AcceptCredential, InetAddress inetAddress) throws KrbException, IOException {
        Object object;
        byte[] byArray;
        EncryptionKey[] encryptionKeyArray;
        Integer n;
        int n2 = this.apReqMessg.ticket.encPart.getEType();
        EncryptionKey encryptionKey = EncryptionKey.findKey(n2, n = this.apReqMessg.ticket.encPart.getKeyVersionNumber(), encryptionKeyArray = krb5AcceptCredential.getKrb5EncryptionKeys(this.apReqMessg.ticket.sname));
        if (encryptionKey == null) {
            throw new KrbException(400, "Cannot find key of appropriate type to decrypt AP REP - " + EType.toString(n2));
        }
        byte[] byArray2 = this.apReqMessg.ticket.encPart.decrypt(encryptionKey, 2);
        byte[] byArray3 = this.apReqMessg.ticket.encPart.reset(byArray2);
        EncTicketPart encTicketPart = new EncTicketPart(byArray3);
        KrbApReq.checkPermittedEType(encTicketPart.key.getEType());
        byte[] byArray4 = this.apReqMessg.authenticator.decrypt(encTicketPart.key, 11);
        byte[] byArray5 = this.apReqMessg.authenticator.reset(byArray4);
        this.authenticator = new Authenticator(byArray5);
        this.ctime = this.authenticator.ctime;
        this.cusec = this.authenticator.cusec;
        this.authenticator.ctime = this.authenticator.ctime.withMicroSeconds(this.authenticator.cusec);
        if (!this.authenticator.cname.equals(encTicketPart.cname)) {
            throw new KrbApErrException(36);
        }
        if (!this.authenticator.ctime.inClockSkew()) {
            throw new KrbApErrException(37);
        }
        String string = AuthTimeWithHash.DEFAULT_HASH_ALG;
        try {
            byArray = MessageDigest.getInstance(AuthTimeWithHash.realAlg(string)).digest(this.apReqMessg.authenticator.cipher);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)("Impossible " + string));
        }
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[2 * i] = hexConst[(byArray[i] & 0xFF) >> 4];
            cArray[2 * i + 1] = hexConst[byArray[i] & 0xF];
        }
        AuthTimeWithHash authTimeWithHash = new AuthTimeWithHash(this.authenticator.cname.toString(), this.apReqMessg.ticket.sname.toString(), this.authenticator.ctime.getSeconds(), this.authenticator.cusec, string, new String(cArray));
        rcache.checkAndStore(KerberosTime.now(), authTimeWithHash);
        if (inetAddress != null) {
            object = new HostAddress(inetAddress);
            if (encTicketPart.caddr != null && !encTicketPart.caddr.inList((HostAddress)object)) {
                if (DEBUG) {
                    System.out.println(">>> KrbApReq: initiator is " + ((HostAddress)object).getInetAddress() + ", but caddr is " + Arrays.toString(encTicketPart.caddr.getInetAddresses()));
                }
                throw new KrbApErrException(38);
            }
        }
        object = KerberosTime.now();
        if (encTicketPart.starttime != null && encTicketPart.starttime.greaterThanWRTClockSkew((KerberosTime)object) || encTicketPart.flags.get(7)) {
            throw new KrbApErrException(33);
        }
        if (encTicketPart.endtime != null && ((KerberosTime)object).greaterThanWRTClockSkew(encTicketPart.endtime)) {
            throw new KrbApErrException(32);
        }
        this.creds = new Credentials(this.apReqMessg.ticket, this.authenticator.cname, null, this.apReqMessg.ticket.sname, null, encTicketPart.key, encTicketPart.flags, encTicketPart.authtime, encTicketPart.starttime, encTicketPart.endtime, encTicketPart.renewTill, encTicketPart.caddr, encTicketPart.authorizationData);
        if (DEBUG) {
            System.out.println(">>> KrbApReq: authenticate succeed.");
        }
    }

    public Credentials getCreds() {
        return this.creds;
    }

    KerberosTime getCtime() {
        if (this.ctime != null) {
            return this.ctime;
        }
        return this.authenticator.ctime;
    }

    int cusec() {
        return this.cusec;
    }

    APOptions getAPOptions() throws KrbException, IOException {
        if (this.apReqMessg == null) {
            this.decode();
        }
        if (this.apReqMessg != null) {
            return this.apReqMessg.apOptions;
        }
        return null;
    }

    public boolean getMutualAuthRequired() throws KrbException, IOException {
        if (this.apReqMessg == null) {
            this.decode();
        }
        if (this.apReqMessg != null) {
            return this.apReqMessg.apOptions.get(2);
        }
        return false;
    }

    boolean useSessionKey() throws KrbException, IOException {
        if (this.apReqMessg == null) {
            this.decode();
        }
        if (this.apReqMessg != null) {
            return this.apReqMessg.apOptions.get(1);
        }
        return false;
    }

    public EncryptionKey getSubKey() {
        return this.authenticator.getSubKey();
    }

    public Integer getSeqNumber() {
        return this.authenticator.getSeqNumber();
    }

    public Checksum getChecksum() {
        return this.authenticator.getChecksum();
    }

    public byte[] getMessage() {
        return this.obuf;
    }

    public PrincipalName getClient() {
        return this.creds.getClient();
    }

    private void createMessage(APOptions aPOptions, Ticket ticket, EncryptionKey encryptionKey, PrincipalName principalName, Checksum checksum, KerberosTime kerberosTime, EncryptionKey encryptionKey2, SeqNumber seqNumber, AuthorizationData authorizationData, int n) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer n2 = null;
        if (seqNumber != null) {
            n2 = new Integer(seqNumber.current());
        }
        this.authenticator = new Authenticator(principalName, checksum, kerberosTime.getMicroSeconds(), kerberosTime, encryptionKey2, n2, authorizationData);
        byte[] byArray = this.authenticator.asn1Encode();
        EncryptedData encryptedData = new EncryptedData(encryptionKey, byArray, n);
        this.apReqMessg = new APReq(aPOptions, ticket, encryptedData);
    }

    private static void checkPermittedEType(int n) throws KrbException {
        int[] nArray = EType.getDefaults("permitted_enctypes");
        if (!EType.isSupported(n, nArray)) {
            throw new KrbException(EType.toString(n) + " encryption type not in permitted_enctypes list");
        }
    }
}

