/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.client;

import com.sparshui.GestureType;
import com.sparshui.client.SparshClient;
import com.sparshui.common.ClientProtocol;
import com.sparshui.common.Event;
import com.sparshui.common.Location;
import com.sparshui.common.messages.events.DragEvent;
import com.sparshui.common.messages.events.FlickEvent;
import com.sparshui.common.messages.events.RelativeDragEvent;
import com.sparshui.common.messages.events.RotateEvent;
import com.sparshui.common.messages.events.SpinEvent;
import com.sparshui.common.messages.events.TouchEvent;
import com.sparshui.common.messages.events.ZoomEvent;
import com.sparshui.common.utils.Converter;
import java.io.IOException;
import java.net.Socket;
import java.util.List;

public class ClientToServerProtocol
extends ClientProtocol {
    public ClientToServerProtocol(Socket socket) throws IOException {
        super(socket);
    }

    public boolean processRequest(SparshClient client) {
        try {
            byte type = this._in.readByte();
            int length = this._in.readInt();
            byte[] data = new byte[length];
            if (length > 0) {
                this._in.readFully(data);
            }
            switch (type) {
                case 0: {
                    this.handleEvents(client, data);
                    break;
                }
                case 1: {
                    this.handleGetGroupID(client, data);
                    break;
                }
                case 2: {
                    this.handleGetAllowedGestures(client, data);
                }
            }
        }
        catch (IOException e) {
            System.err.println("[Client Protocol] GestureServer Connection Lost");
            this.handleEvents(client, null);
            return false;
        }
        return true;
    }

    private void handleEvents(SparshClient client, byte[] data) {
        if (data == null) {
            client.processEvent(-1, null);
            return;
        }
        if (data.length < 1) {
            return;
        }
        int groupID = Converter.byteArrayToInt(data);
        int eventType = Converter.byteArrayToInt(data, 4);
        byte[] newData = new byte[data.length - 8];
        System.arraycopy(data, 8, newData, 0, data.length - 8);
        Event event = null;
        switch (eventType) {
            case -2: {
                client.processEvent(-2, null);
                return;
            }
            case 0: {
                event = new DragEvent(newData);
                break;
            }
            case 1: {
                event = new RotateEvent(newData);
                break;
            }
            case 2: {
                event = new SpinEvent();
                break;
            }
            case 3: {
                event = new TouchEvent(newData);
                break;
            }
            case 4: {
                event = new ZoomEvent(newData);
                break;
            }
            case 6: {
                event = new FlickEvent(newData);
                break;
            }
            case 7: {
                event = new RelativeDragEvent(newData);
            }
        }
        if (event != null) {
            client.processEvent(groupID, event);
        }
    }

    private void handleGetGroupID(SparshClient client, byte[] data) throws IOException {
        this._out.writeInt(client.getGroupID(new Location(Converter.byteArrayToFloat(data, 0), Converter.byteArrayToFloat(data, 4))));
    }

    private void handleGetAllowedGestures(SparshClient client, byte[] data) throws IOException {
        GestureType gType;
        int i;
        List<GestureType> gestureTypes = client.getAllowedGestures(Converter.byteArrayToInt(data));
        int length = gestureTypes == null ? 0 : gestureTypes.size();
        int blen = length * 4;
        for (i = 0; i < length; ++i) {
            gType = gestureTypes.get(i);
            if (gType.sType == null) continue;
            blen += gType.sType.length();
        }
        this._out.writeInt(blen);
        for (i = 0; i < length; ++i) {
            gType = gestureTypes.get(i);
            if (gType.sType == null) {
                this._out.writeInt(gType.iType);
                continue;
            }
            int len = gType.sType.length();
            if (len <= 0) continue;
            this._out.writeInt(-len);
            this._out.write(Converter.stringToByteArray(gType.sType));
        }
    }
}

