/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing;

import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.testing.GenericTestReportGenerator;
import org.gradle.api.internal.tasks.testing.LegacyTestReportGenerator;
import org.gradle.api.internal.tasks.testing.TestReportGenerator;
import org.gradle.api.internal.tasks.testing.report.generic.MetadataRendererRegistry;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.instrumentation.api.annotations.ReplacedAccessor;
import org.gradle.internal.instrumentation.api.annotations.ReplacedDeprecation;
import org.gradle.internal.instrumentation.api.annotations.ReplacesEagerProperty;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class TestReport
extends DefaultTask {
    @Inject
    protected abstract BuildOperationRunner getBuildOperationRunner();

    @Inject
    protected abstract BuildOperationExecutor getBuildOperationExecutor();

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract MetadataRendererRegistry getMetadataRendererRegistry();

    @OutputDirectory
    @ReplacesEagerProperty(replacedAccessors={@ReplacedAccessor(value=ReplacedAccessor.AccessorType.GETTER, name="getDestinationDir"), @ReplacedAccessor(value=ReplacedAccessor.AccessorType.SETTER, name="setDestinationDir")}, deprecation=@ReplacedDeprecation(removedIn=ReplacedDeprecation.RemovedIn.GRADLE9))
    public abstract DirectoryProperty getDestinationDirectory();

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getTestResults();

    @TaskAction
    void generateReport() {
        try {
            TestReportGenerator impl = this.detectAndCreateImplementation((FileCollection)this.getTestResults());
            if (impl.hasResults()) {
                impl.generateReport(this.getBuildOperationRunner(), this.getBuildOperationExecutor(), ((Directory)this.getDestinationDirectory().get()).getAsFile().toPath());
            } else {
                this.getLogger().info("{} - no binary test results found in dirs: {}.", (Object)this.getPath(), (Object)this.getTestResults().getFiles());
                this.setDidWork(false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write test report for results in " + this.getTestResults().getFiles(), e);
        }
    }

    TestReportGenerator detectAndCreateImplementation(FileCollection resultDirs) {
        Boolean isGenericImplementation = null;
        for (File resultDir : resultDirs.getFiles()) {
            boolean resultDirIsGenericImplementation = SerializableTestResultStore.isGenericTestResults((File)resultDir);
            if (isGenericImplementation == null) {
                isGenericImplementation = resultDirIsGenericImplementation;
                continue;
            }
            if (isGenericImplementation == resultDirIsGenericImplementation) continue;
            throw new IllegalStateException("Cannot mix generic and non-generic test results in the same report.");
        }
        assert (isGenericImplementation != null) : "@SkipWhenEmpty should prevent this from being called with an empty collection";
        if (isGenericImplementation.booleanValue()) {
            return new GenericTestReportGenerator((Collection)resultDirs.getFiles().stream().map(File::toPath).collect(Collectors.toSet()), this.getMetadataRendererRegistry());
        }
        return new LegacyTestReportGenerator(resultDirs);
    }
}

