/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import tim.prune.cmd.Command;
import tim.prune.cmd.InsertAudioCmd;
import tim.prune.data.AudioClip;
import tim.prune.data.TrackInfo;

public class RemoveAudioCmd
extends Command {
    private final int _audioIndex;

    public RemoveAudioCmd(int n) {
        this(null, n);
    }

    protected RemoveAudioCmd(Command command, int n) {
        super(command);
        this._audioIndex = n;
    }

    @Override
    public int getUpdateFlags() {
        return 16;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        try {
            trackInfo.getAudioList().delete(this._audioIndex);
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        AudioClip audioClip = trackInfo.getAudioList().get(this._audioIndex);
        return new InsertAudioCmd(this, audioClip, this._audioIndex);
    }
}

