/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.SecurityHelper;
import io.sf.carte.echosvg.script.rhino.RhinoClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import org.mozilla.javascript.WrappedException;

class SMSecurityHelper
extends SecurityHelper {
    @Override
    Object runPrivilegedAction(PrivilegedAction<?> action) {
        try {
            return AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            throw new WrappedException((Throwable)e);
        }
    }

    @Override
    Object runPrivilegedAction(PrivilegedAction<?> action, Object securityDomain) {
        AccessControlContext acc;
        if (securityDomain instanceof AccessControlContext) {
            acc = (AccessControlContext)securityDomain;
        } else {
            RhinoClassLoader loader = (RhinoClassLoader)securityDomain;
            acc = (AccessControlContext)loader.getAccessControlObject();
        }
        try {
            return AccessController.doPrivileged(action, acc);
        }
        catch (Exception e) {
            throw new WrappedException((Throwable)e);
        }
    }

    @Override
    PermissionCollection getPermissions(CodeSource codesource) {
        Policy p = Policy.getPolicy();
        PermissionCollection pc = null;
        if (p != null) {
            pc = p.getPermissions(codesource);
        }
        return pc;
    }
}

