/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.cli;

import android.databinding.tool.util.L;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Landroid/databinding/cli/ZipUtil;", "", "()V", "unzip", "", "file", "Ljava/io/File;", "outFolder", "zip", "folder", "outFile", "exec"})
public final class ZipUtil {
    public static final ZipUtil INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unzip(@NotNull File file, @NotNull File outFolder) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)outFolder, (String)"outFolder");
        if (!outFolder.exists() && !outFolder.mkdirs()) {
            throw (Throwable)new RuntimeException("unable to create out folder " + outFolder.getAbsolutePath());
        }
        ZipFile zipFile = new ZipFile(file);
        Closeable closeable = zipFile;
        Throwable throwable = null;
        try {
            Iterator $receiver$iv;
            Iterator iterator;
            ZipFile it = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"zipFile.entries()");
            Iterator iterator2 = iterator = ($receiver$iv = CollectionsKt.iterator(enumeration));
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                ZipEntry entry = (ZipEntry)element$iv;
                boolean bl2 = false;
                ZipEntry zipEntry = entry;
                Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"entry");
                if (zipEntry.isDirectory()) {
                    new File(outFolder, entry.getName()).mkdirs();
                    continue;
                }
                Closeable closeable2 = zipFile.getInputStream(entry);
                Throwable throwable2 = null;
                try {
                    InputStream it2 = (InputStream)closeable2;
                    boolean bl3 = false;
                    File file2 = new File(outFolder, entry.getName());
                    InputStream inputStream = zipFile.getInputStream(entry);
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"zipFile.getInputStream(entry)");
                    FilesKt.writeBytes((File)file2, (byte[])ByteStreamsKt.readBytes((InputStream)inputStream, (int)1000));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void zip(@NotNull File folder, @NotNull File outFile) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        Intrinsics.checkParameterIsNotNull((Object)outFile, (String)"outFile");
        int inputAbsPath = folder.getAbsolutePath().length();
        FileOutputStream fos = new FileOutputStream(outFile);
        Closeable closeable = fos;
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            ZipOutputStream zos = new ZipOutputStream(fos);
            Closeable closeable2 = zos;
            Throwable throwable2 = null;
            try {
                void $receiver$iv;
                ZipOutputStream it2 = (ZipOutputStream)closeable2;
                boolean bl2 = false;
                Collection collection = FileUtils.listFiles((File)folder, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"FileUtils.listFiles(fold\u2026 TrueFileFilter.INSTANCE)");
                Iterable iterable = collection;
                for (Object element$iv : $receiver$iv) {
                    String string;
                    String string2;
                    File file = (File)element$iv;
                    boolean bl3 = false;
                    File file2 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2.getAbsolutePath(), (String)"file.absolutePath");
                    int n = inputAbsPath + 1;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                    String string4 = string;
                    ZipEntry entry = new ZipEntry(string4);
                    try {
                        zos.putNextEntry(entry);
                        zos.write(FilesKt.readBytes((File)file));
                        zos.closeEntry();
                    }
                    catch (Throwable t) {
                        L.e((Throwable)t, (String)"cannot write zip file. Filed on %s", (Object[])new Object[]{file});
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private ZipUtil() {
    }

    static {
        ZipUtil zipUtil;
        INSTANCE = zipUtil = new ZipUtil();
    }
}

