﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dms/DatabaseMigrationService_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DatabaseMigrationService {
namespace Model {

/**
 * <p>Information about a data provider.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DataProviderDescriptor">AWS
 * API Reference</a></p>
 */
class DataProviderDescriptor {
 public:
  AWS_DATABASEMIGRATIONSERVICE_API DataProviderDescriptor() = default;
  AWS_DATABASEMIGRATIONSERVICE_API DataProviderDescriptor(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATABASEMIGRATIONSERVICE_API DataProviderDescriptor& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATABASEMIGRATIONSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the Amazon Web Services Secrets Manager Secret used to
   * store access credentials for the data provider.</p>
   */
  inline const Aws::String& GetSecretsManagerSecretId() const { return m_secretsManagerSecretId; }
  inline bool SecretsManagerSecretIdHasBeenSet() const { return m_secretsManagerSecretIdHasBeenSet; }
  template <typename SecretsManagerSecretIdT = Aws::String>
  void SetSecretsManagerSecretId(SecretsManagerSecretIdT&& value) {
    m_secretsManagerSecretIdHasBeenSet = true;
    m_secretsManagerSecretId = std::forward<SecretsManagerSecretIdT>(value);
  }
  template <typename SecretsManagerSecretIdT = Aws::String>
  DataProviderDescriptor& WithSecretsManagerSecretId(SecretsManagerSecretIdT&& value) {
    SetSecretsManagerSecretId(std::forward<SecretsManagerSecretIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the role used to access Amazon Web Services Secrets Manager.</p>
   */
  inline const Aws::String& GetSecretsManagerAccessRoleArn() const { return m_secretsManagerAccessRoleArn; }
  inline bool SecretsManagerAccessRoleArnHasBeenSet() const { return m_secretsManagerAccessRoleArnHasBeenSet; }
  template <typename SecretsManagerAccessRoleArnT = Aws::String>
  void SetSecretsManagerAccessRoleArn(SecretsManagerAccessRoleArnT&& value) {
    m_secretsManagerAccessRoleArnHasBeenSet = true;
    m_secretsManagerAccessRoleArn = std::forward<SecretsManagerAccessRoleArnT>(value);
  }
  template <typename SecretsManagerAccessRoleArnT = Aws::String>
  DataProviderDescriptor& WithSecretsManagerAccessRoleArn(SecretsManagerAccessRoleArnT&& value) {
    SetSecretsManagerAccessRoleArn(std::forward<SecretsManagerAccessRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user-friendly name of the data provider.</p>
   */
  inline const Aws::String& GetDataProviderName() const { return m_dataProviderName; }
  inline bool DataProviderNameHasBeenSet() const { return m_dataProviderNameHasBeenSet; }
  template <typename DataProviderNameT = Aws::String>
  void SetDataProviderName(DataProviderNameT&& value) {
    m_dataProviderNameHasBeenSet = true;
    m_dataProviderName = std::forward<DataProviderNameT>(value);
  }
  template <typename DataProviderNameT = Aws::String>
  DataProviderDescriptor& WithDataProviderName(DataProviderNameT&& value) {
    SetDataProviderName(std::forward<DataProviderNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the data provider.</p>
   */
  inline const Aws::String& GetDataProviderArn() const { return m_dataProviderArn; }
  inline bool DataProviderArnHasBeenSet() const { return m_dataProviderArnHasBeenSet; }
  template <typename DataProviderArnT = Aws::String>
  void SetDataProviderArn(DataProviderArnT&& value) {
    m_dataProviderArnHasBeenSet = true;
    m_dataProviderArn = std::forward<DataProviderArnT>(value);
  }
  template <typename DataProviderArnT = Aws::String>
  DataProviderDescriptor& WithDataProviderArn(DataProviderArnT&& value) {
    SetDataProviderArn(std::forward<DataProviderArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_secretsManagerSecretId;

  Aws::String m_secretsManagerAccessRoleArn;

  Aws::String m_dataProviderName;

  Aws::String m_dataProviderArn;
  bool m_secretsManagerSecretIdHasBeenSet = false;
  bool m_secretsManagerAccessRoleArnHasBeenSet = false;
  bool m_dataProviderNameHasBeenSet = false;
  bool m_dataProviderArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace DatabaseMigrationService
}  // namespace Aws
