"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.attributeCanHaveEventModifier = attributeCanHaveEventModifier;
exports.inStyleOrScript = inStyleOrScript;
const documents_1 = require("../../../lib/documents");
const utils_1 = require("../../../utils");
function attributeCanHaveEventModifier(attributeContext) {
    return (!attributeContext.inValue &&
        !(0, utils_1.possiblyComponent)(attributeContext.elementTag) &&
        attributeContext.name.startsWith('on:') &&
        attributeContext.name.includes('|'));
}
function inStyleOrScript(svelteDoc, position) {
    return ((0, documents_1.isInTag)(position, svelteDoc.style) ||
        (0, documents_1.isInTag)(position, svelteDoc.script) ||
        (0, documents_1.isInTag)(position, svelteDoc.moduleScript));
}
//# sourceMappingURL=utils.js.map