/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.ebnf.Zigzag;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;

public class ETileOptional2
extends ETile {
    private final double deltax = 24.0;
    private final double deltay = 20.0;
    private final ETile orig;
    private final ISkinParam skinParam;
    private String commentAbove;
    private String commentBelow;

    public ETileOptional2(ETile orig, ISkinParam skinParam) {
        this.skinParam = skinParam;
        this.orig = orig;
    }

    @Override
    public double getH1(StringBounder stringBounder) {
        TextBlock note = this.getNoteAbove(stringBounder);
        return 10.0 + note.calculateDimension(stringBounder).getHeight();
    }

    private double getDeltaY(StringBounder stringBounder) {
        TextBlock note = this.getNoteAbove(stringBounder);
        return 20.0 + note.calculateDimension(stringBounder).getHeight();
    }

    @Override
    public double getH2(StringBounder stringBounder) {
        TextBlock note = this.getNoteBelow(stringBounder);
        return 10.0 + this.orig.getH1(stringBounder) + this.orig.getH2(stringBounder) + note.calculateDimension(stringBounder).getHeight();
    }

    @Override
    public double getWidth(StringBounder stringBounder) {
        return this.orig.getWidth(stringBounder) + 48.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        TextBlock noteBelow;
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dim = this.calculateDimension(stringBounder);
        double linePos = this.getH1(stringBounder);
        this.drawHlineDirected(ug, linePos, 0.0, dim.getWidth(), 0.4, 25.0);
        double corner = 12.0;
        Zigzag zigzag = new Zigzag(9.0, 24.0, this.getDeltaY(stringBounder) + this.orig.getH1(stringBounder) - linePos);
        ug.apply(new UTranslate(0.0, linePos)).draw(zigzag.pathDown());
        ug.apply(new UTranslate(dim.getWidth() - 24.0, linePos)).draw(zigzag.pathUp());
        this.orig.drawU(ug.apply(new UTranslate(24.0, this.getDeltaY(stringBounder))));
        TextBlock noteAbove = this.getNoteAbove(stringBounder);
        if (noteAbove != TextBlockUtils.EMPTY_TEXT_BLOCK) {
            double pos2 = (dim.getWidth() - noteAbove.calculateDimension(stringBounder).getWidth()) / 2.0;
            noteAbove.drawU(ug.apply(UTranslate.dx(pos2)));
        }
        if ((noteBelow = this.getNoteBelow(stringBounder)) != TextBlockUtils.EMPTY_TEXT_BLOCK) {
            XDimension2D dimBelow = noteBelow.calculateDimension(stringBounder);
            double pos2 = (dim.getWidth() - dimBelow.getWidth()) / 2.0;
            noteBelow.drawU(ug.apply(new UTranslate(pos2, dim.getHeight() - dimBelow.getHeight())));
        }
    }

    @Override
    public void push(ETile tile) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void addCommentAbove(String comment) {
        this.commentAbove = comment;
    }

    @Override
    protected void addCommentBelow(String comment) {
        this.commentBelow = comment;
    }

    private TextBlock getNoteAbove(StringBounder stringBounder) {
        if (this.commentAbove == null) {
            return TextBlockUtils.EMPTY_TEXT_BLOCK;
        }
        FloatingNote note = FloatingNote.create(Display.getWithNewlines(this.skinParam.getPragma(), this.commentAbove), this.skinParam, SName.ebnf);
        return TextBlockUtils.withMargin(note, 0.0, 0.0, 0.0, 10.0);
    }

    private TextBlock getNoteBelow(StringBounder stringBounder) {
        if (this.commentBelow == null) {
            return TextBlockUtils.EMPTY_TEXT_BLOCK;
        }
        FloatingNote note = FloatingNote.create(Display.getWithNewlines(this.skinParam.getPragma(), this.commentBelow), this.skinParam, SName.ebnf);
        return TextBlockUtils.withMargin(note, 0.0, 0.0, 10.0, 0.0);
    }
}

