/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.sql.domain;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.json.JSONObject;
import org.opensearch.sql.protocol.response.format.Format;

public class SQLQueryRequest {
    private static final String QUERY_FIELD_CURSOR = "cursor";
    private static final Set<String> SUPPORTED_FIELDS = Set.of("query", "fetch_size", "parameters", "cursor");
    private static final String QUERY_PARAMS_FORMAT = "format";
    private static final String QUERY_PARAMS_SANITIZE = "sanitize";
    private static final String QUERY_PARAMS_PRETTY = "pretty";
    private final JSONObject jsonContent;
    private final String query;
    private final String path;
    private final String format;
    private Map<String, String> params = Collections.emptyMap();
    private boolean sanitize = true;
    private boolean pretty = false;
    private String cursor;

    public SQLQueryRequest(JSONObject jsonContent, String query, String path, Map<String, String> params, String cursor) {
        this.jsonContent = jsonContent;
        this.query = query;
        this.path = path;
        this.params = params;
        this.format = this.getFormat(params);
        this.sanitize = this.shouldSanitize(params);
        this.pretty = this.shouldPretty(params);
        this.cursor = cursor;
    }

    public boolean isSupported() {
        boolean validQuery;
        boolean hasCursor = this.isCursor();
        boolean hasQuery = this.query != null;
        boolean hasContent = this.jsonContent != null && !this.jsonContent.isEmpty();
        Predicate<String> supportedParams = Set.of(QUERY_PARAMS_FORMAT, QUERY_PARAMS_PRETTY)::contains;
        boolean hasUnsupportedParams = !this.params.isEmpty() && this.params.keySet().stream().dropWhile(supportedParams).findAny().isPresent();
        boolean validCursor = hasCursor && !hasQuery && !hasUnsupportedParams && !hasContent;
        boolean bl = validQuery = !hasCursor && hasQuery;
        return (validCursor || validQuery) && this.isOnlySupportedFieldInPayload() && (this.isExplainRequest() ? this.isSupportedExplainFormat() : this.isSupportedFormat());
    }

    private boolean isCursor() {
        return this.cursor != null && !this.cursor.isEmpty();
    }

    public boolean isExplainRequest() {
        return this.path.endsWith("/_explain");
    }

    public boolean isCursorCloseRequest() {
        return this.path.endsWith("/close");
    }

    public Format format() {
        Optional optionalFormat = Format.of((String)this.format);
        if (optionalFormat.isPresent()) {
            return (Format)optionalFormat.get();
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "response in %s format is not supported.", this.format));
    }

    private boolean isOnlySupportedFieldInPayload() {
        return this.jsonContent == null || SUPPORTED_FIELDS.containsAll(this.jsonContent.keySet());
    }

    public Optional<String> getCursor() {
        return Optional.ofNullable(this.cursor);
    }

    public int getFetchSize() {
        return this.jsonContent.optInt("fetch_size");
    }

    private boolean isSupportedFormat() {
        return Stream.of("csv", "jdbc", "raw").anyMatch(this.format::equalsIgnoreCase);
    }

    private boolean isSupportedExplainFormat() {
        return Stream.of("simple", "standard", "extended", "cost").anyMatch(this.format::equalsIgnoreCase);
    }

    private String getFormat(Map<String, String> params) {
        return params.getOrDefault(QUERY_PARAMS_FORMAT, this.isExplainRequest() ? "standard" : "jdbc");
    }

    private boolean shouldSanitize(Map<String, String> params) {
        if (params.containsKey(QUERY_PARAMS_SANITIZE)) {
            return Boolean.parseBoolean(params.get(QUERY_PARAMS_SANITIZE));
        }
        return true;
    }

    private boolean shouldPretty(Map<String, String> params) {
        if (params.containsKey(QUERY_PARAMS_PRETTY)) {
            return Boolean.parseBoolean(params.get(QUERY_PARAMS_PRETTY));
        }
        return false;
    }

    @Generated
    public String toString() {
        return "SQLQueryRequest(jsonContent=" + String.valueOf(this.jsonContent) + ", query=" + this.getQuery() + ", path=" + this.path + ", format=" + this.getFormat() + ", params=" + String.valueOf(this.params) + ", sanitize=" + this.sanitize() + ", pretty=" + this.pretty() + ", cursor=" + String.valueOf(this.getCursor()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLQueryRequest)) {
            return false;
        }
        SQLQueryRequest other = (SQLQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.sanitize() != other.sanitize()) {
            return false;
        }
        if (this.pretty() != other.pretty()) {
            return false;
        }
        JSONObject this$jsonContent = this.jsonContent;
        JSONObject other$jsonContent = other.jsonContent;
        if (this$jsonContent == null ? other$jsonContent != null : !this$jsonContent.equals(other$jsonContent)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$path = this.path;
        String other$path = other.path;
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        Map<String, String> this$params = this.params;
        Map<String, String> other$params = other.params;
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        Optional<String> this$cursor = this.getCursor();
        Optional<String> other$cursor = other.getCursor();
        return !(this$cursor == null ? other$cursor != null : !((Object)this$cursor).equals(other$cursor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SQLQueryRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sanitize() ? 79 : 97);
        result = result * 59 + (this.pretty() ? 79 : 97);
        JSONObject $jsonContent = this.jsonContent;
        result = result * 59 + ($jsonContent == null ? 43 : $jsonContent.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        Map<String, String> $params = this.params;
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        Optional<String> $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : ((Object)$cursor).hashCode());
        return result;
    }

    @Generated
    public SQLQueryRequest(JSONObject jsonContent, String query, String path, String format) {
        this.jsonContent = jsonContent;
        this.query = query;
        this.path = path;
        this.format = format;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public boolean sanitize() {
        return this.sanitize;
    }

    @Generated
    public boolean pretty() {
        return this.pretty;
    }
}

