/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DDBJsonTransformer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private DDBJsonTransformer() {
    }

    public static Map<String, AttributeValue> convertJsonObjectToDDBAttributeMap(JsonNode jsonNode) {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            if (((JsonNode)field.getValue()).isTextual()) {
                item.put((String)field.getKey(), (AttributeValue)AttributeValue.builder().s(((JsonNode)field.getValue()).asText()).build());
                continue;
            }
            if (((JsonNode)field.getValue()).isNumber()) {
                item.put((String)field.getKey(), (AttributeValue)AttributeValue.builder().n(((JsonNode)field.getValue()).asText()).build());
                continue;
            }
            if (((JsonNode)field.getValue()).isBoolean()) {
                item.put((String)field.getKey(), (AttributeValue)AttributeValue.builder().bool(Boolean.valueOf(((JsonNode)field.getValue()).asBoolean())).build());
                continue;
            }
            if (((JsonNode)field.getValue()).isNull()) {
                item.put((String)field.getKey(), (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build());
                continue;
            }
            if (((JsonNode)field.getValue()).isObject()) {
                item.put((String)field.getKey(), (AttributeValue)AttributeValue.builder().m(DDBJsonTransformer.convertJsonObjectToDDBAttributeMap((JsonNode)field.getValue())).build());
                continue;
            }
            if (((JsonNode)field.getValue()).isArray()) {
                item.put((String)field.getKey(), (AttributeValue)AttributeValue.builder().l(DDBJsonTransformer.convertJsonArrayToAttributeValueList((JsonNode)field.getValue())).build());
                continue;
            }
            throw new IllegalArgumentException("Unsupported field type: " + String.valueOf(field.getValue()));
        }
        return item;
    }

    public static List<AttributeValue> convertJsonArrayToAttributeValueList(JsonNode jsonArray) {
        ArrayList<AttributeValue> attributeValues = new ArrayList<AttributeValue>();
        for (JsonNode element : jsonArray) {
            if (element.isTextual()) {
                attributeValues.add((AttributeValue)AttributeValue.builder().s(element.asText()).build());
                continue;
            }
            if (element.isNumber()) {
                attributeValues.add((AttributeValue)AttributeValue.builder().n(element.asText()).build());
                continue;
            }
            if (element.isBoolean()) {
                attributeValues.add((AttributeValue)AttributeValue.builder().bool(Boolean.valueOf(element.asBoolean())).build());
                continue;
            }
            if (element.isNull()) {
                attributeValues.add((AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build());
                continue;
            }
            if (element.isObject()) {
                attributeValues.add((AttributeValue)AttributeValue.builder().m(DDBJsonTransformer.convertJsonObjectToDDBAttributeMap(element)).build());
                continue;
            }
            if (element.isArray()) {
                attributeValues.add((AttributeValue)AttributeValue.builder().l(DDBJsonTransformer.convertJsonArrayToAttributeValueList(element)).build());
                continue;
            }
            throw new IllegalArgumentException("Unsupported field type: " + String.valueOf(element));
        }
        return attributeValues;
    }

    public static ObjectNode convertDDBAttributeValueMapToObjectNode(Map<String, AttributeValue> item) {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        item.forEach((key, value) -> {
            switch (value.type()) {
                case S: {
                    objectNode.put(key, value.s());
                    break;
                }
                case N: {
                    objectNode.put(key, value.n());
                    break;
                }
                case BOOL: {
                    objectNode.put(key, value.bool());
                    break;
                }
                case L: {
                    objectNode.set(key, (JsonNode)DDBJsonTransformer.convertAttributeValueListToArrayNode(value.l()));
                    break;
                }
                case M: {
                    objectNode.set(key, (JsonNode)DDBJsonTransformer.convertDDBAttributeValueMapToObjectNode(value.m()));
                    break;
                }
                case NUL: {
                    objectNode.putNull(key);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported AttributeValue type: " + String.valueOf(value.type()));
                }
            }
        });
        return objectNode;
    }

    public static ArrayNode convertAttributeValueListToArrayNode(List<AttributeValue> attributeValueList) {
        ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
        attributeValueList.forEach(attribute -> {
            switch (attribute.type()) {
                case S: {
                    arrayNode.add(attribute.s());
                    break;
                }
                case N: {
                    arrayNode.add(attribute.n());
                    break;
                }
                case BOOL: {
                    arrayNode.add(attribute.bool());
                    break;
                }
                case L: {
                    arrayNode.add((JsonNode)DDBJsonTransformer.convertAttributeValueListToArrayNode(attribute.l()));
                    break;
                }
                case M: {
                    arrayNode.add((JsonNode)DDBJsonTransformer.convertDDBAttributeValueMapToObjectNode(attribute.m()));
                    break;
                }
                case NUL: {
                    arrayNode.add((JsonNode)null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported AttributeValue type: " + String.valueOf(attribute.type()));
                }
            }
        });
        return arrayNode;
    }
}

