/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class KeyValueProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, KeyValueProcessor> {
    @Nonnull
    private final List<String> excludeKeys;
    @Nonnull
    private final String field;
    @Nonnull
    private final String fieldSplit;
    @Nullable
    private final Boolean ignoreMissing;
    @Nonnull
    private final List<String> includeKeys;
    @Nullable
    private final String prefix;
    @Nullable
    private final Boolean stripBrackets;
    @Nullable
    private final String targetField;
    @Nullable
    private final String trimKey;
    @Nullable
    private final String trimValue;
    @Nonnull
    private final String valueSplit;
    public static final JsonpDeserializer<KeyValueProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeyValueProcessor::setupKeyValueProcessorDeserializer);

    private KeyValueProcessor(Builder builder) {
        super(builder);
        this.excludeKeys = ApiTypeHelper.unmodifiable(builder.excludeKeys);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.fieldSplit = ApiTypeHelper.requireNonNull(builder.fieldSplit, this, "fieldSplit");
        this.ignoreMissing = builder.ignoreMissing;
        this.includeKeys = ApiTypeHelper.unmodifiable(builder.includeKeys);
        this.prefix = builder.prefix;
        this.stripBrackets = builder.stripBrackets;
        this.targetField = builder.targetField;
        this.trimKey = builder.trimKey;
        this.trimValue = builder.trimValue;
        this.valueSplit = ApiTypeHelper.requireNonNull(builder.valueSplit, this, "valueSplit");
    }

    public static KeyValueProcessor of(Function<Builder, ObjectBuilder<KeyValueProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Kv;
    }

    @Nonnull
    public final List<String> excludeKeys() {
        return this.excludeKeys;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nonnull
    public final String fieldSplit() {
        return this.fieldSplit;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nonnull
    public final List<String> includeKeys() {
        return this.includeKeys;
    }

    @Nullable
    public final String prefix() {
        return this.prefix;
    }

    @Nullable
    public final Boolean stripBrackets() {
        return this.stripBrackets;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Nullable
    public final String trimKey() {
        return this.trimKey;
    }

    @Nullable
    public final String trimValue() {
        return this.trimValue;
    }

    @Nonnull
    public final String valueSplit() {
        return this.valueSplit;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.excludeKeys)) {
            generator.writeKey("exclude_keys");
            generator.writeStartArray();
            for (String item0 : this.excludeKeys) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("field_split");
        generator.write(this.fieldSplit);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.includeKeys)) {
            generator.writeKey("include_keys");
            generator.writeStartArray();
            for (String item0 : this.includeKeys) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.prefix != null) {
            generator.writeKey("prefix");
            generator.write(this.prefix);
        }
        if (this.stripBrackets != null) {
            generator.writeKey("strip_brackets");
            generator.write(this.stripBrackets.booleanValue());
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.trimKey != null) {
            generator.writeKey("trim_key");
            generator.write(this.trimKey);
        }
        if (this.trimValue != null) {
            generator.writeKey("trim_value");
            generator.write(this.trimValue);
        }
        generator.writeKey("value_split");
        generator.write(this.valueSplit);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupKeyValueProcessorDeserializer(ObjectDeserializer<Builder> op) {
        KeyValueProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::excludeKeys, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "exclude_keys");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::fieldSplit, JsonpDeserializer.stringDeserializer(), "field_split");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::includeKeys, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "include_keys");
        op.add(Builder::prefix, JsonpDeserializer.stringDeserializer(), "prefix");
        op.add(Builder::stripBrackets, JsonpDeserializer.booleanDeserializer(), "strip_brackets");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::trimKey, JsonpDeserializer.stringDeserializer(), "trim_key");
        op.add(Builder::trimValue, JsonpDeserializer.stringDeserializer(), "trim_value");
        op.add(Builder::valueSplit, JsonpDeserializer.stringDeserializer(), "value_split");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.excludeKeys);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.fieldSplit.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreMissing);
        result = 31 * result + Objects.hashCode(this.includeKeys);
        result = 31 * result + Objects.hashCode(this.prefix);
        result = 31 * result + Objects.hashCode(this.stripBrackets);
        result = 31 * result + Objects.hashCode(this.targetField);
        result = 31 * result + Objects.hashCode(this.trimKey);
        result = 31 * result + Objects.hashCode(this.trimValue);
        result = 31 * result + this.valueSplit.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValueProcessor other = (KeyValueProcessor)o;
        return Objects.equals(this.excludeKeys, other.excludeKeys) && this.field.equals(other.field) && this.fieldSplit.equals(other.fieldSplit) && Objects.equals(this.ignoreMissing, other.ignoreMissing) && Objects.equals(this.includeKeys, other.includeKeys) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.stripBrackets, other.stripBrackets) && Objects.equals(this.targetField, other.targetField) && Objects.equals(this.trimKey, other.trimKey) && Objects.equals(this.trimValue, other.trimValue) && this.valueSplit.equals(other.valueSplit);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, KeyValueProcessor> {
        @Nullable
        private List<String> excludeKeys;
        private String field;
        private String fieldSplit;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private List<String> includeKeys;
        @Nullable
        private String prefix;
        @Nullable
        private Boolean stripBrackets;
        @Nullable
        private String targetField;
        @Nullable
        private String trimKey;
        @Nullable
        private String trimValue;
        private String valueSplit;

        public Builder() {
        }

        private Builder(KeyValueProcessor o) {
            super(o);
            this.excludeKeys = Builder._listCopy(o.excludeKeys);
            this.field = o.field;
            this.fieldSplit = o.fieldSplit;
            this.ignoreMissing = o.ignoreMissing;
            this.includeKeys = Builder._listCopy(o.includeKeys);
            this.prefix = o.prefix;
            this.stripBrackets = o.stripBrackets;
            this.targetField = o.targetField;
            this.trimKey = o.trimKey;
            this.trimValue = o.trimValue;
            this.valueSplit = o.valueSplit;
        }

        private Builder(Builder o) {
            super(o);
            this.excludeKeys = Builder._listCopy(o.excludeKeys);
            this.field = o.field;
            this.fieldSplit = o.fieldSplit;
            this.ignoreMissing = o.ignoreMissing;
            this.includeKeys = Builder._listCopy(o.includeKeys);
            this.prefix = o.prefix;
            this.stripBrackets = o.stripBrackets;
            this.targetField = o.targetField;
            this.trimKey = o.trimKey;
            this.trimValue = o.trimValue;
            this.valueSplit = o.valueSplit;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder excludeKeys(List<String> list) {
            this.excludeKeys = Builder._listAddAll(this.excludeKeys, list);
            return this;
        }

        @Nonnull
        public final Builder excludeKeys(String value, String ... values) {
            this.excludeKeys = Builder._listAdd(this.excludeKeys, value, values);
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder fieldSplit(String value) {
            this.fieldSplit = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public final Builder includeKeys(List<String> list) {
            this.includeKeys = Builder._listAddAll(this.includeKeys, list);
            return this;
        }

        @Nonnull
        public final Builder includeKeys(String value, String ... values) {
            this.includeKeys = Builder._listAdd(this.includeKeys, value, values);
            return this;
        }

        @Nonnull
        public final Builder prefix(@Nullable String value) {
            this.prefix = value;
            return this;
        }

        @Nonnull
        public final Builder stripBrackets(@Nullable Boolean value) {
            this.stripBrackets = value;
            return this;
        }

        @Nonnull
        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Nonnull
        public final Builder trimKey(@Nullable String value) {
            this.trimKey = value;
            return this;
        }

        @Nonnull
        public final Builder trimValue(@Nullable String value) {
            this.trimValue = value;
            return this;
        }

        @Nonnull
        public final Builder valueSplit(String value) {
            this.valueSplit = value;
            return this;
        }

        @Override
        @Nonnull
        public KeyValueProcessor build() {
            this._checkSingleUse();
            return new KeyValueProcessor(this);
        }
    }
}

