/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.addpolicy;

import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.Index;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import org.opensearch.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import org.opensearch.indexmanagement.indexstatemanagement.model.Policy;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.ISMStatusResponse;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.addpolicy.AddPolicyRequest;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.addpolicy.TransportAddPolicyAction;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.addpolicy.TransportAddPolicyActionKt;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexAction;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexRequest;
import org.opensearch.indexmanagement.indexstatemanagement.util.FailedIndex;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.opensearchapi.IndexManagementSecurityContext;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.spi.indexstatemanagement.IndexMetadataService;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ISMIndexMetadata;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002/0BA\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J&\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00022\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030.H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010!R\u0018\u0010\"\u001a\n  *\u0004\u0018\u00010#0#X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010$R\u0018\u0010%\u001a\n  *\u0004\u0018\u00010&0&X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'\u00a8\u00061"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/TransportAddPolicyAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/AddPolicyRequest;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/ISMStatusResponse;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "indexMetadataProvider", "Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "<init>", "(Lorg/opensearch/transport/client/node/NodeClient;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;)V", "getClient", "()Lorg/opensearch/transport/client/node/NodeClient;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "getIndexMetadataProvider", "()Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "jobInterval", "", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "jobJitter", "", "Ljava/lang/Double;", "filterByEnabled", "", "Ljava/lang/Boolean;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/core/action/ActionListener;", "AddPolicyHandler", "Companion", "opensearch-index-management"})
public final class TransportAddPolicyAction
extends HandledTransportAction<AddPolicyRequest, ISMStatusResponse> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NodeClient client;
    @NotNull
    private final Settings settings;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final IndexMetadataProvider indexMetadataProvider;
    private volatile Integer jobInterval;
    private volatile Double jobJitter;
    private volatile Boolean filterByEnabled;
    public static final long ADD_POLICY_TIMEOUT_IN_MILLIS = 30000L;

    @Inject
    public TransportAddPolicyAction(@NotNull NodeClient client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull IndexMetadataProvider indexMetadataProvider) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)indexMetadataProvider, (String)"indexMetadataProvider");
        super("cluster:admin/opendistro/ism/managedindex/add", transportService, actionFilters, AddPolicyRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.indexMetadataProvider = indexMetadataProvider;
        this.jobInterval = (Integer)ManagedIndexSettings.Companion.getJOB_INTERVAL().get(this.settings);
        this.jobJitter = (Double)ManagedIndexSettings.Companion.getJITTER().get(this.settings);
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getJOB_INTERVAL(), arg_0 -> TransportAddPolicyAction._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getJITTER(), arg_0 -> TransportAddPolicyAction._init_$lambda$1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportAddPolicyAction._init_$lambda$2(this, arg_0));
    }

    @NotNull
    public final NodeClient getClient() {
        return this.client;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final IndexMetadataProvider getIndexMetadataProvider() {
        return this.indexMetadataProvider;
    }

    protected void doExecute(@NotNull Task task, @NotNull AddPolicyRequest request, @NotNull ActionListener<ISMStatusResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new AddPolicyHandler(this, this.client, listener, request, null, 8, null).start();
    }

    private static final void _init_$lambda$0(TransportAddPolicyAction this$0, Integer it) {
        this$0.jobInterval = it;
    }

    private static final void _init_$lambda$1(TransportAddPolicyAction this$0, Double it) {
        this$0.jobJitter = it;
    }

    private static final void _init_$lambda$2(TransportAddPolicyAction this$0, Boolean it) {
        this$0.filterByEnabled = it;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u001c\u0010\u001a\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001cH\u0082@\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0018H\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010!\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u0018H\u0002J\b\u0010&\u001a\u00020\u0018H\u0002J\u0014\u0010'\u001a\u00020\u00182\n\u0010(\u001a\u00060)j\u0002`*H\u0002J\u0014\u0010+\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020,0\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/TransportAddPolicyAction$AddPolicyHandler;", "", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/ISMStatusResponse;", "request", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/AddPolicyRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "<init>", "(Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/TransportAddPolicyAction;Lorg/opensearch/transport/client/node/NodeClient;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/AddPolicyRequest;Lorg/opensearch/commons/authuser/User;)V", "startTime", "Ljava/time/Instant;", "policy", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/Policy;", "indicesToAdd", "", "", "failedIndices", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/util/FailedIndex;", "start", "", "getClusterState", "validateIndexPermissions", "indices", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeClosedIndices", "getPolicy", "onGetPolicyResponse", "response", "Lorg/opensearch/action/get/GetResponse;", "onUpdateMapping", "Lorg/opensearch/action/support/clustermanager/AcknowledgedResponse;", "getExistingManagedIndices", "createManagedIndices", "onFailure", "t", "Ljava/lang/Exception;", "Lkotlin/Exception;", "removeMetadatas", "Lorg/opensearch/core/index/Index;", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nTransportAddPolicyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportAddPolicyAction.kt\norg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/TransportAddPolicyAction$AddPolicyHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,397:1\n1869#2,2:398\n1563#2:408\n1634#2,3:409\n37#3:400\n36#3,3:401\n216#4,2:404\n216#4,2:406\n*S KotlinDebug\n*F\n+ 1 TransportAddPolicyAction.kt\norg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/TransportAddPolicyAction$AddPolicyHandler\n*L\n164#1:398,2\n376#1:408\n376#1:409,3\n189#1:400\n189#1:401,3\n282#1:404,2\n326#1:406,2\n*E\n"})
    public final class AddPolicyHandler {
        @NotNull
        private final NodeClient client;
        @NotNull
        private final ActionListener<ISMStatusResponse> actionListener;
        @NotNull
        private final AddPolicyRequest request;
        @Nullable
        private final User user;
        private Instant startTime;
        private Policy policy;
        @NotNull
        private final Map<String, String> indicesToAdd;
        @NotNull
        private final List<FailedIndex> failedIndices;
        final /* synthetic */ TransportAddPolicyAction this$0;

        public AddPolicyHandler(@NotNull TransportAddPolicyAction this$0, @NotNull NodeClient client, @NotNull ActionListener<ISMStatusResponse> actionListener, @Nullable AddPolicyRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.this$0 = this$0;
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
            this.indicesToAdd = new LinkedHashMap();
            this.failedIndices = new ArrayList();
        }

        public /* synthetic */ AddPolicyHandler(TransportAddPolicyAction transportAddPolicyAction, NodeClient nodeClient, ActionListener actionListener, AddPolicyRequest addPolicyRequest, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = nodeClient.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"getThreadContext(...)");
                user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
            }
            this(transportAddPolicyAction, nodeClient, (ActionListener<ISMStatusResponse>)actionListener, addPolicyRequest, user);
        }

        public final void start() {
            TransportAddPolicyActionKt.access$getLog$p().debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            Boolean bl = this.this$0.filterByEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"access$getFilterByEnabled$p(...)");
            if (!SecurityUtils.Companion.validateUserConfiguration(this.user, bl, this.actionListener)) {
                return;
            }
            this.getClusterState();
        }

        private final void getClusterState() {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            this.startTime = instant;
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransportAddPolicyAction this$0;
                final /* synthetic */ AddPolicyHandler this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            indexNameToMetadata = new HashMap<K, V>();
                            var12_5 = indexNameToMetadata;
                            this.L$0 = indexNameToMetadata;
                            this.L$1 = var12_5;
                            this.label = 1;
                            v0 = this.this$0.getIndexMetadataProvider().getISMIndexMetadataByType(AddPolicyHandler.access$getRequest$p(this.this$1).getIndexType(), AddPolicyHandler.access$getRequest$p(this.this$1).getIndices(), (Continuation<? super Map<String, ISMIndexMetadata>>)((Continuation)this));
                            ** if (v0 != var13_2) goto lbl15
lbl14:
                            // 1 sources

                            return var13_2;
lbl15:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        case 1: {
                            var12_5 = (Map)this.L$1;
                            indexNameToMetadata = (Map)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl23:
                                // 2 sources

                                var12_5.putAll((Map)v0);
                            }
                            catch (Exception e) {
                                v1 = AddPolicyHandler.access$getActionListener$p(this.this$1);
                                v2 = ExceptionsHelper.unwrapCause((Throwable)e);
                                Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type java.lang.Exception");
                                v1.onFailure((Exception)v2);
                                return Unit.INSTANCE;
                            }
                            e = indexNameToMetadata;
                            var4_8 = this.this$1;
                            $i$f$forEach = false;
                            var6_10 = $this$forEach$iv.entrySet().iterator();
                            while (var6_10.hasNext()) {
                                var8_12 = element$iv = var6_10.next();
                                $i$a$-forEach-TransportAddPolicyAction$AddPolicyHandler$getClusterState$1$1 = false;
                                indexName = (String)var8_12.getKey();
                                indexMetadata = (ISMIndexMetadata)var8_12.getValue();
                                AddPolicyHandler.access$getIndicesToAdd$p(var4_8).putIfAbsent(indexMetadata.getIndexUuid(), indexName);
                            }
                            if (AddPolicyHandler.access$getIndicesToAdd$p(this.this$1).isEmpty()) {
                                AddPolicyHandler.access$getActionListener$p(this.this$1).onResponse((Object)new ISMStatusResponse(0, AddPolicyHandler.access$getFailedIndices$p(this.this$1)));
                                return Unit.INSTANCE;
                            }
                            if (AddPolicyHandler.access$getUser$p(this.this$1) != null) {
                                v3 = this.this$0.getSettings();
                                v4 = AddPolicyHandler.access$getClient$p(this.this$1).threadPool().getThreadContext();
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getThreadContext(...)");
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)indexNameToMetadata);
                                this.L$1 = null;
                                this.label = 2;
                                v5 = OpenSearchExtensionsKt.withClosableContext(new IndexManagementSecurityContext("AddPolicyHandler", v3, v4, AddPolicyHandler.access$getUser$p(this.this$1)), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, null){
                                    int label;
                                    final /* synthetic */ AddPolicyHandler this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = AddPolicyHandler.access$validateIndexPermissions(this.this$0, CollectionsKt.toList((Iterable)AddPolicyHandler.access$getIndicesToAdd$p(this.this$0).values()), (Continuation)this);
                                                if (object2 != object) return Unit.INSTANCE;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, (Continuation)this);
                                if (v5 == var13_2) {
                                    return var13_2;
                                }
                            }
                            ** GOTO lbl62
                        }
                        case 2: {
                            indexNameToMetadata = (Map)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl62:
                            // 2 sources

                            AddPolicyHandler.access$removeClosedIndices(this.this$1);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * Unable to fully structure code
         */
        private final Object validateIndexPermissions(List<String> indices, Continuation<? super Unit> $completion) {
            if (!($completion instanceof validateIndexPermissions.1)) ** GOTO lbl-1000
            var12_3 = $completion;
            if ((var12_3.label & -2147483648) != 0) {
                var12_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ AddPolicyHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return AddPolicyHandler.access$validateIndexPermissions(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    permittedIndices = new ArrayList<E>();
                    $this$forEach$iv = indices;
                    $i$f$forEach = 0;
                    var6_9 = $this$forEach$iv.iterator();
lbl16:
                    // 3 sources

                    while (var6_9.hasNext()) {
                        element$iv = var6_9.next();
                        index = (String)element$iv;
                        $i$a$-forEach-TransportAddPolicyAction$AddPolicyHandler$validateIndexPermissions$2 = 0;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)indices);
                        $continuation.L$1 = permittedIndices;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                        $continuation.L$3 = var6_9;
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                        $continuation.L$5 = index;
                        $continuation.I$0 = $i$f$forEach;
                        $continuation.I$1 = $i$a$-forEach-TransportAddPolicyAction$AddPolicyHandler$validateIndexPermissions$2;
                        $continuation.label = 1;
                        v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, validateIndexPermissions$lambda$1$lambda$0(java.lang.String org.opensearch.transport.client.node.NodeClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/node/NodeClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((String)index), $continuation);
                        ** if (v0 != var13_5) goto lbl34
lbl33:
                        // 1 sources

                        return var13_5;
lbl34:
                        // 1 sources

                        ** GOTO lbl49
                    }
                    break;
                }
                case 1: {
                    $i$a$-forEach-TransportAddPolicyAction$AddPolicyHandler$validateIndexPermissions$2 = $continuation.I$1;
                    $i$f$forEach = $continuation.I$0;
                    index = (String)$continuation.L$5;
                    element$iv = $continuation.L$4;
                    var6_9 = (Iterator)$continuation.L$3;
                    $this$forEach$iv = (Iterable)$continuation.L$2;
                    permittedIndices = (List)$continuation.L$1;
                    indices = (List)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl49:
                        // 2 sources

                        permittedIndices.add(index);
                    }
                    catch (OpenSearchSecurityException e) {
                        TransportAddPolicyActionKt.access$getLog$p().debug("No permissions for index [" + index + "]");
                    }
                    ** GOTO lbl16
                }
            }
            if (permittedIndices.isEmpty()) {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
                return Unit.INSTANCE;
            }
            this.indicesToAdd.values().removeIf((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, validateIndexPermissions$lambda$3(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, validateIndexPermissions$lambda$2(java.util.List java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)((List)permittedIndices)));
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final void removeClosedIndices() {
            if (Intrinsics.areEqual((Object)this.request.getIndexType(), (Object)"_default")) {
                IndicesOptions strictExpandOptions = IndicesOptions.strictExpand();
                Collection<String> $this$toTypedArray$iv = this.indicesToAdd.values();
                boolean $i$f$toTypedArray = false;
                Collection<String> thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(Arrays.copyOf(stringArray, stringArray.length)).metadata(true).local(false)).waitForTimeout(TimeValue.timeValueMillis((long)30000L)).indicesOptions(strictExpandOptions);
                this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(this.this$0, this){
                    final /* synthetic */ TransportAddPolicyAction this$0;
                    final /* synthetic */ AddPolicyHandler this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onResponse(ClusterStateResponse response2) {
                        void $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexMetadataService indexMetadataService = this.this$0.getIndexMetadataProvider().getServices().get("_default");
                        Intrinsics.checkNotNull((Object)indexMetadataService, (String)"null cannot be cast to non-null type org.opensearch.indexmanagement.indexstatemanagement.DefaultIndexMetadataService");
                        DefaultIndexMetadataService defaultIndexMetadataService = (DefaultIndexMetadataService)indexMetadataService;
                        ClusterState clusterState = response2.getState();
                        Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"getState(...)");
                        Iterable iterable = org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt.getUuidsForClosedIndices(clusterState, defaultIndexMetadataService);
                        AddPolicyHandler addPolicyHandler = this.this$1;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            List list = AddPolicyHandler.access$getFailedIndices$p(addPolicyHandler);
                            V v = AddPolicyHandler.access$getIndicesToAdd$p(addPolicyHandler).get(it);
                            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                            list.add(new FailedIndex((String)v, it, "This index is closed"));
                            AddPolicyHandler.access$getIndicesToAdd$p(addPolicyHandler).remove(it);
                        }
                        AddPolicyHandler.access$getPolicy(this.this$1);
                    }

                    public void onFailure(Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        ActionListener actionListener = AddPolicyHandler.access$getActionListener$p(this.this$1);
                        Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                        Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception");
                        actionListener.onFailure((Exception)throwable);
                    }
                });
            } else {
                this.getPolicy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void getPolicy() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.getPolicyID());
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            TransportAddPolicyAction transportAddPolicyAction = this.this$0;
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                Boolean bl2 = transportAddPolicyAction.filterByEnabled;
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"access$getFilterByEnabled$p(...)");
                if (!SecurityUtils.Companion.validateUserConfiguration(this.user, bl2, this.actionListener)) {
                    return;
                }
                this.client.get(getRequest, ActionListener.wrap(this::onGetPolicyResponse, this::onFailure));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final void onGetPolicyResponse(GetResponse response2) {
            if (!response2.isExists() || response2.isSourceEmpty()) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Could not find policy=" + this.request.getPolicyID(), RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            try {
                this.policy = (Policy)OpenSearchExtensionsKt.parseFromGetResponse(response2, this.this$0.getXContentRegistry(), (Function4)new Function4<XContentParser, String, Long, Long, Policy>((Object)Policy.Companion){

                    public final Policy invoke(XContentParser p0, String p1, long p2, long p3) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return ((Policy.Companion)this.receiver).parse(p0, p1, p2, p3);
                    }
                });
            }
            catch (IllegalArgumentException e) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Could not find policy=" + this.request.getPolicyID(), RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            Policy policy2 = this.policy;
            if (policy2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"policy");
                policy2 = null;
            }
            User user = policy2.getUser();
            Boolean bl = this.this$0.filterByEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"access$getFilterByEnabled$p(...)");
            if (!SecurityUtils.Companion.userHasPermissionForResource(this.user, user, bl, "policy", this.request.getPolicyID(), this.actionListener)) {
                return;
            }
            ClusterState clusterState = this.this$0.getClusterService().state();
            Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"state(...)");
            IndicesAdminClient indicesAdminClient = this.client.admin().indices();
            Intrinsics.checkNotNullExpressionValue((Object)indicesAdminClient, (String)"indices(...)");
            ActionListener actionListener = ActionListener.wrap(this::onUpdateMapping, this::onFailure);
            Intrinsics.checkNotNullExpressionValue((Object)actionListener, (String)"wrap(...)");
            IndexUtils.Companion.checkAndUpdateConfigIndexMapping(clusterState, indicesAdminClient, (ActionListener<AcknowledgedResponse>)actionListener);
        }

        private final void onUpdateMapping(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportAddPolicyActionKt.access$getLog$p().info("Successfully created or updated .opendistro-ism-config with newest mappings.");
                this.getExistingManagedIndices();
            } else {
                TransportAddPolicyActionKt.access$getLog$p().error("Unable to create or update .opendistro-ism-config with newest mapping.");
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Unable to create or update .opendistro-ism-config with newest mapping.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void getExistingManagedIndices() {
            this.indicesToAdd.entrySet().removeIf(arg_0 -> AddPolicyHandler.getExistingManagedIndices$lambda$6(arg_0 -> AddPolicyHandler.getExistingManagedIndices$lambda$5(this.this$0, this, arg_0), arg_0));
            if (this.indicesToAdd.isEmpty()) {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
                return;
            }
            MultiGetRequest multiGetReq = new MultiGetRequest();
            Map<String, String> $this$forEach$iv = this.indicesToAdd;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl = false;
                multiGetReq.add(".opendistro-ism-config", it.getKey());
            }
            this.client.multiGet(multiGetReq, (ActionListener)new ActionListener<MultiGetResponse>(this){
                final /* synthetic */ AddPolicyHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onResponse(MultiGetResponse response2) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    Iterable iterable = (Iterable)response2;
                    AddPolicyHandler addPolicyHandler = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        MultiGetItemResponse it = (MultiGetItemResponse)element$iv;
                        boolean bl = false;
                        if (!it.getResponse().isExists()) continue;
                        String docId = it.getId();
                        List list = AddPolicyHandler.access$getFailedIndices$p(addPolicyHandler);
                        V v = AddPolicyHandler.access$getIndicesToAdd$p(addPolicyHandler).get(docId);
                        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                        String string = (String)v;
                        Intrinsics.checkNotNull((Object)docId);
                        list.add(new FailedIndex(string, docId, "This index already has a policy, use the update policy API to update index policies"));
                        AddPolicyHandler.access$getIndicesToAdd$p(addPolicyHandler).remove(docId);
                    }
                    AddPolicyHandler.access$createManagedIndices(this.this$0);
                }

                public void onFailure(Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    ActionListener actionListener = AddPolicyHandler.access$getActionListener$p(this.this$0);
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception");
                    actionListener.onFailure((Exception)throwable);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void createManagedIndices() {
            if (!this.indicesToAdd.isEmpty()) {
                void $this$forEach$iv;
                Instant instant = this.startTime;
                if (instant == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"startTime");
                    instant = null;
                }
                Duration duration = Duration.between(instant, Instant.now());
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
                Duration timeSinceClusterStateRequest = duration;
                long bulkReqTimeout = 30000L - timeSinceClusterStateRequest.toMillis();
                if (bulkReqTimeout < 0L) {
                    this.actionListener.onFailure((Exception)new OpenSearchTimeoutException("Add policy API timed out after ClusterStateResponse", new Object[0]));
                    return;
                }
                BulkRequest bulkReq = new BulkRequest().timeout(TimeValue.timeValueMillis((long)bulkReqTimeout));
                Map<String, String> map = this.indicesToAdd;
                TransportAddPolicyAction transportAddPolicyAction = this.this$0;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    String uuid = (String)entry.getKey();
                    String name = (String)entry.getValue();
                    String string = this.request.getPolicyID();
                    Integer n = transportAddPolicyAction.jobInterval;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"access$getJobInterval$p(...)");
                    int n2 = ((Number)n).intValue();
                    Policy policy2 = this.policy;
                    if (policy2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"policy");
                        policy2 = null;
                    }
                    bulkReq.add(ManagedIndexUtils.managedIndexConfigIndexRequest(name, uuid, string, n2, Policy.copy$default(policy2, null, 0L, 0L, null, 0L, null, null, null, null, null, this.user, 1023, null), transportAddPolicyAction.jobJitter));
                }
                this.client.bulk(bulkReq, (ActionListener)new ActionListener<BulkResponse>(this){
                    final /* synthetic */ AddPolicyHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onResponse(BulkResponse response2) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Object docId;
                        Map $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        Iterable iterable = (Iterable)response2;
                        AddPolicyHandler addPolicyHandler = this.this$0;
                        boolean $i$f$forEach22 = false;
                        Iterator<T> iterator = $this$forEach$iv.iterator();
                        while (iterator.hasNext()) {
                            T element$iv = iterator.next();
                            BulkItemResponse it = (BulkItemResponse)element$iv;
                            boolean bl = false;
                            docId = it.getId();
                            if (!it.isFailed()) continue;
                            List list = AddPolicyHandler.access$getFailedIndices$p(addPolicyHandler);
                            V v = AddPolicyHandler.access$getIndicesToAdd$p(addPolicyHandler).get(docId);
                            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                            String string = (String)v;
                            Intrinsics.checkNotNull((Object)docId);
                            list.add(new FailedIndex(string, (String)docId, "Failed to add policy due to: " + it.getFailureMessage()));
                            AddPolicyHandler.access$getIndicesToAdd$p(addPolicyHandler).remove(docId);
                        }
                        AddPolicyHandler.access$getActionListener$p(this.this$0).onResponse((Object)((Object)new ISMStatusResponse(AddPolicyHandler.access$getIndicesToAdd$p(this.this$0).size(), AddPolicyHandler.access$getFailedIndices$p(this.this$0))));
                        $this$forEach$iv = AddPolicyHandler.access$getIndicesToAdd$p(this.this$0);
                        AddPolicyHandler addPolicyHandler2 = this.this$0;
                        boolean $i$f$map = false;
                        void $i$f$forEach22 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                        boolean $i$f$mapTo = false;
                        for (Map.Entry<K, V> item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                            void it;
                            docId = item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new Index((String)it.getValue(), (String)it.getKey()));
                        }
                        addPolicyHandler2.removeMetadatas((List)destination$iv$iv);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onFailure(Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        if (t instanceof ClusterBlockException) {
                            void $this$forEach$iv;
                            Map map = AddPolicyHandler.access$getIndicesToAdd$p(this.this$0);
                            AddPolicyHandler addPolicyHandler = this.this$0;
                            boolean $i$f$forEach = false;
                            Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry<K, V> element$iv;
                                Map.Entry<K, V> entry = element$iv = iterator.next();
                                boolean bl = false;
                                String uuid = (String)entry.getKey();
                                String name = (String)entry.getValue();
                                AddPolicyHandler.access$getFailedIndices$p(addPolicyHandler).add(new FailedIndex(name, uuid, "Failed to add policy due to ClusterBlockingException: " + t.getMessage()));
                            }
                            AddPolicyHandler.access$getActionListener$p(this.this$0).onResponse((Object)((Object)new ISMStatusResponse(0, AddPolicyHandler.access$getFailedIndices$p(this.this$0))));
                        } else {
                            ActionListener actionListener = AddPolicyHandler.access$getActionListener$p(this.this$0);
                            Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                            Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception");
                            actionListener.onFailure((Exception)throwable);
                        }
                    }
                });
            } else {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
            }
        }

        private final void onFailure(Exception t) {
            Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
            Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception");
            this.actionListener.onFailure((Exception)throwable);
        }

        /*
         * WARNING - void declaration
         */
        public final void removeMetadatas(@NotNull List<? extends Index> indices) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(indices, (String)"indices");
            Iterable $this$map$iv = indices;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Index index2 = (Index)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUUID(...)");
                collection.add(ManagedIndexUtils.deleteManagedIndexMetadataRequest(string));
            }
            List request = (List)destination$iv$iv;
            BulkRequest bulkReq = new BulkRequest().add((Iterable)request);
            this.client.bulk(bulkReq, (ActionListener)new ActionListener<BulkResponse>(indices){
                final /* synthetic */ List<Index> $indices;
                {
                    this.$indices = $indices;
                }

                public void onResponse(BulkResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    TransportAddPolicyActionKt.access$getLog$p().debug("Successfully cleaned metadata for remove policy indices: {}", this.$indices);
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    TransportAddPolicyActionKt.access$getLog$p().error("Failed to clean metadata for remove policy indices.", (Throwable)e);
                }
            });
        }

        private static final Unit validateIndexPermissions$lambda$1$lambda$0(String $index, NodeClient $this$suspendUntil, ActionListener it) {
            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String[] stringArray = new String[]{$index};
            $this$suspendUntil.execute((ActionType)ManagedIndexAction.Companion.getINSTANCE(), (ActionRequest)new ManagedIndexRequest(new String[0]).indices(stringArray), it);
            return Unit.INSTANCE;
        }

        private static final boolean validateIndexPermissions$lambda$2(List $permittedIndices, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !$permittedIndices.contains(it);
        }

        private static final boolean validateIndexPermissions$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean getExistingManagedIndices$lambda$5(TransportAddPolicyAction this$0, AddPolicyHandler this$1, Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            String uuid = (String)entry.getKey();
            String indexName = (String)entry.getValue();
            boolean shouldRemove = this$0.getIndexMetadataProvider().isUnManageableIndex(indexName);
            if (shouldRemove) {
                this$1.failedIndices.add(new FailedIndex(indexName, uuid, "Matches restricted index pattern defined in the cluster setting"));
            }
            return shouldRemove;
        }

        private static final boolean getExistingManagedIndices$lambda$6(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ AddPolicyRequest access$getRequest$p(AddPolicyHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(AddPolicyHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ Map access$getIndicesToAdd$p(AddPolicyHandler $this) {
            return $this.indicesToAdd;
        }

        public static final /* synthetic */ List access$getFailedIndices$p(AddPolicyHandler $this) {
            return $this.failedIndices;
        }

        public static final /* synthetic */ User access$getUser$p(AddPolicyHandler $this) {
            return $this.user;
        }

        public static final /* synthetic */ NodeClient access$getClient$p(AddPolicyHandler $this) {
            return $this.client;
        }

        public static final /* synthetic */ Object access$validateIndexPermissions(AddPolicyHandler $this, List indices, Continuation $completion) {
            return $this.validateIndexPermissions(indices, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ void access$removeClosedIndices(AddPolicyHandler $this) {
            $this.removeClosedIndices();
        }

        public static final /* synthetic */ void access$getPolicy(AddPolicyHandler $this) {
            $this.getPolicy();
        }

        public static final /* synthetic */ void access$createManagedIndices(AddPolicyHandler $this) {
            $this.createManagedIndices();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/TransportAddPolicyAction$Companion;", "", "<init>", "()V", "ADD_POLICY_TIMEOUT_IN_MILLIS", "", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

