"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ismPlugin;
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
    TODO: migrate to types
 * Types are not available until 7.2
 * https://github.com/opensearch-project/OpenSearch-Dashboards/blob/main/src/core/server/opensearch/client/client_config.ts
 * */
function ismPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.ism = components.clientAction.namespaceFactory();
  const ism = Client.prototype.ism.prototype;
  ism.getPolicy = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}/<%=policyId%>`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getPolicies = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}`
    },
    method: "GET"
  });
  ism.createPolicy = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}/<%=policyId%>?refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.deletePolicy = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}/<%=policyId%>?refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
  ism.putPolicy = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}/<%=policyId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        },
        ifSeqNo: {
          type: "string",
          required: true
        },
        ifPrimaryTerm: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.explain = ca({
    url: {
      fmt: `${_constants.API.EXPLAIN_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.explainAll = ca({
    url: {
      fmt: `${_constants.API.EXPLAIN_BASE}`
    },
    method: "GET"
  });
  ism.retry = ca({
    url: {
      fmt: `${_constants.API.RETRY_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    needBody: false,
    method: "POST"
  });
  ism.add = ca({
    url: {
      fmt: `${_constants.API.ADD_POLICY_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "POST"
  });
  ism.remove = ca({
    url: {
      fmt: `${_constants.API.REMOVE_POLICY_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    needBody: false,
    method: "POST"
  });
  ism.change = ca({
    url: {
      fmt: `${_constants.API.CHANGE_POLICY_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "POST"
  });

  // TODO add new APIs as they are being implemented: status, stop, start

  ism.getRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getRollups = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}`
    },
    method: "GET"
  });
  ism.createRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>?refresh=wait_for`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.deleteRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>?refresh=wait_for`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
  ism.putRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "PUT"
  });
  ism.startRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>/_start`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.stopRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>/_stop`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.explainRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>/_explain`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getTransforms = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/`
    },
    method: "GET"
  });
  ism.explainTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>/_explain`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.startTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>/_start`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.stopTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>/_stop`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.deleteTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
  ism.createTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>?refresh=wait_for`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.putTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "PUT"
  });
  ism.previewTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/_preview`
    },
    needBody: true,
    method: "POST"
  });
  ism.getChannels = ca({
    url: {
      fmt: `${_constants.API.CHANNELS_BASE}`
    },
    method: "GET"
  });
  ism.getChannel = ca({
    url: {
      fmt: `${_constants.API.NOTIFICATION_CONFIGS_BASE}/<%=id%>`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getSMPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=id%>`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getSMPolicies = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}`
    },
    method: "GET"
  });
  ism.createSMPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=policyId%>?refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "POST"
  });
  ism.updateSMPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=policyId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        },
        ifSeqNo: {
          type: "string",
          required: true
        },
        ifPrimaryTerm: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.deleteSMPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=policyId%>?refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
  ism.explainSnapshotPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=id%>/_explain`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.startSnapshotPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=id%>/_start`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.stopSnapshotPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=id%>/_stop`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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