"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.MESSAGE_ID_LENGTH = exports.MessageIdLength = exports.FRAME_LENGTH = exports.Maximum = exports.SequenceIdentifier = exports.ObjectType = exports.ContentAADString = exports.ContentType = exports.SerializationVersion = exports.ENCODED_SIGNER_KEY = void 0;
/*
 * This public interface for constants is provided for
 * the use of the Encryption SDK for JavaScript only.  It can be used
 * as a reference but is not intended to be use by any packages other
 * than the Encryption SDK for JavaScript.
 *
 * See: https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/reference.html
 *
 * https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/message-format.html#header-aad (algorithms with signing)
 * https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/message-format.html#header-version
 * https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/message-format.html#header-content-type
 * https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/body-aad-reference.html (Body AAD Content)
 * https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/message-format.html#header-type
 * https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/body-aad-reference.html#body-aad-sequence-number
 */
exports.ENCODED_SIGNER_KEY = 'aws-crypto-public-key';
/** @deprecated use import { MessageFormat } from '@aws-crypto/material-management' */
var material_management_1 = require("@aws-crypto/material-management");
Object.defineProperty(exports, "SerializationVersion", { enumerable: true, get: function () { return material_management_1.MessageFormat; } });
var ContentType;
(function (ContentType) {
    ContentType[ContentType["NO_FRAMING"] = 1] = "NO_FRAMING";
    ContentType[ContentType["FRAMED_DATA"] = 2] = "FRAMED_DATA";
})(ContentType = exports.ContentType || (exports.ContentType = {}));
Object.freeze(ContentType);
var ContentAADString;
(function (ContentAADString) {
    ContentAADString["FRAME_STRING_ID"] = "AWSKMSEncryptionClient Frame";
    ContentAADString["FINAL_FRAME_STRING_ID"] = "AWSKMSEncryptionClient Final Frame";
    ContentAADString["NON_FRAMED_STRING_ID"] = "AWSKMSEncryptionClient Single Block";
})(ContentAADString = exports.ContentAADString || (exports.ContentAADString = {}));
Object.freeze(ContentAADString);
var ObjectType;
(function (ObjectType) {
    ObjectType[ObjectType["CUSTOMER_AE_DATA"] = 128] = "CUSTOMER_AE_DATA";
})(ObjectType = exports.ObjectType || (exports.ObjectType = {}));
Object.freeze(ObjectType);
var SequenceIdentifier;
(function (SequenceIdentifier) {
    SequenceIdentifier[SequenceIdentifier["SEQUENCE_NUMBER_END"] = 4294967295] = "SEQUENCE_NUMBER_END";
})(SequenceIdentifier = exports.SequenceIdentifier || (exports.SequenceIdentifier = {}));
Object.freeze(SequenceIdentifier);
var Maximum;
(function (Maximum) {
    // Maximum number of messages which are allowed to be encrypted under a single cached data key
    Maximum[Maximum["MESSAGES_PER_CACHED_KEY_LIMIT"] = 4294967296] = "MESSAGES_PER_CACHED_KEY_LIMIT";
    /* Maximum number of bytes that are allowed to be encrypted
     * under a single cached data key across messages.
     * The maximum value defined in the AWS Encryption SDK specification is 2 ** 63 - 1.
     * However Javascript can only perform safe operations on values
     * up to Number.MAX_SAFE_INTEGER === 9007199254740991 === 2 ** 53 - 1.
     * e.g
     * Number.MAX_SAFE_INTEGER + 1 === Number.MAX_SAFE_INTEGER + 2 => true
     * Number.MAX_SAFE_INTEGER + 1 > Number.MAX_SAFE_INTEGER + 2 => false
     * Number.MAX_SAFE_INTEGER + 1 < Number.MAX_SAFE_INTEGER + 2 => false
     *
     * This means that after 2 ** 53 - 1 the process of accumulating a byte count
     * will never yield an accurate comparison and so, never halt.
     *
     * The choice here to use 2 ** 53 - 1 instead of Number.MAX_SAFE_INTEGER is deliberate.
     * This is because in the future Number.MAX_SAFE_INTEGER could be raised to 2 ** 66
     * or some value larger 2 ** 63.
     */
    Maximum[Maximum["BYTES_PER_CACHED_KEY_LIMIT"] = 9007199254740991] = "BYTES_PER_CACHED_KEY_LIMIT";
    /* This value should be Maximum.FRAME_COUNT * Maximum.FRAME_SIZE.
     * However this would be ~ 2 ** 64, much larger than Number.MAX_SAFE_INTEGER.
     * For the same reasons outlined above in BYTES_PER_CACHED_KEY_LIMIT
     * this value is set to 2 ** 53 - 1.
     */
    Maximum[Maximum["BYTES_PER_MESSAGE"] = 9007199254740991] = "BYTES_PER_MESSAGE";
    /* Maximum number of bytes for a single AES-GCM "operation."
     * This is related to the GHASH block size,
     * and can be thought of as the maximum bytes
     * that can be encrypted with a single key/IV pair.
     * The AWS Encryption SDK for Javascript
     * does not support non-framed encrypt
     * https://github.com/awslabs/aws-encryption-sdk-specification/blob/master/data-format/message-body.md#non-framed-data
     * So this value is only needed to ensure
     * that messages submitted for decrypt
     * are well formed.
     */
    Maximum[Maximum["BYTES_PER_AES_GCM_NONCE"] = 68719476704] = "BYTES_PER_AES_GCM_NONCE";
    // Maximum number of frames allowed in one message as defined in specification
    Maximum[Maximum["FRAME_COUNT"] = 4294967295] = "FRAME_COUNT";
    // Maximum bytes allowed in a single frame as defined in specification
    Maximum[Maximum["FRAME_SIZE"] = 4294967295] = "FRAME_SIZE";
    // Maximum bytes allowed in a non-framed message ciphertext as defined in specification
    Maximum[Maximum["GCM_CONTENT_SIZE"] = 4294967295] = "GCM_CONTENT_SIZE";
    Maximum[Maximum["NON_FRAMED_SIZE"] = 4294967295] = "NON_FRAMED_SIZE";
    // Maximum number of AAD bytes allowed as defined in specification
    Maximum[Maximum["AAD_BYTE_SIZE"] = 65535] = "AAD_BYTE_SIZE";
})(Maximum = exports.Maximum || (exports.Maximum = {}));
Object.freeze(Maximum);
// Default frame length when using framing
exports.FRAME_LENGTH = 4096;
// Message ID length as defined in specification
var MessageIdLength;
(function (MessageIdLength) {
    MessageIdLength[MessageIdLength["V1"] = 16] = "V1";
    MessageIdLength[MessageIdLength["V2"] = 32] = "V2";
})(MessageIdLength = exports.MessageIdLength || (exports.MessageIdLength = {}));
Object.freeze(MessageIdLength);
/** @deprecated use MessageIdLength */
exports.MESSAGE_ID_LENGTH = MessageIdLength.V1;
//# sourceMappingURL=data:application/json;base64,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