/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

@Deprecated
public class OracleStruct
extends DatumWithConnection
implements oracle.jdbc.internal.OracleStruct,
Diagnosable {
    private static final String CLASS_NAME = OracleStruct.class.getName();
    StructDescriptor descriptor;
    Datum[] datumArray;
    Object[] objectArray;
    boolean enableLocalCache = false;
    long imageOffset;
    long imageLength;
    Object acProxy;

    public OracleStruct(StructDescriptor type, Connection conn, Object[] attributes) throws SQLException {
        OracleStruct.assertNotNull(type);
        this.descriptor = type;
        OracleStruct.assertNotNull(conn);
        if (!type.getInternalConnection().isDescriptorSharable(((OracleConnection)conn).physicalConnectionWithin())) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance, invalid connection").fillInStackTrace();
        }
        type.setConnection(conn);
        if (!this.descriptor.isInstantiable()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance for a non-instantiable object type").fillInStackTrace();
        }
        this.setPhysicalConnectionOf(conn);
        this.datumArray = attributes != null ? this.descriptor.toArray(attributes) : new Datum[this.descriptor.getLength()];
    }

    public OracleStruct(StructDescriptor type, Connection conn, Map<?, ?> attrList) throws SQLException {
        OracleStruct.assertNotNull(type);
        this.descriptor = type;
        OracleStruct.assertNotNull(conn);
        if (!type.getInternalConnection().isDescriptorSharable(((OracleConnection)conn).physicalConnectionWithin())) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance, invalid connection").fillInStackTrace();
        }
        type.setConnection(conn);
        if (!this.descriptor.isInstantiable()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance for a non-instantiable object type").fillInStackTrace();
        }
        this.setPhysicalConnectionOf(conn);
        this.datumArray = this.descriptor.toOracleArray(attrList);
    }

    public OracleStruct(StructDescriptor type, byte[] elements, Connection conn) throws SQLException {
        super(elements);
        OracleStruct.assertNotNull(type);
        this.descriptor = type;
        OracleStruct.assertNotNull(conn);
        if (!type.getInternalConnection().isDescriptorSharable(((OracleConnection)conn).physicalConnectionWithin())) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance, invalid connection").fillInStackTrace();
        }
        type.setConnection(conn);
        this.setPhysicalConnectionOf(conn);
        this.datumArray = null;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            String string = this.descriptor.getName();
            return string;
        }
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            Object[] ret;
            Object[] objectArray = ret = this.getAttributes(this.getMap());
            return objectArray;
        }
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            Object[] objectArray = this.descriptor.toArray(this, this, map, this.enableLocalCache);
            return objectArray;
        }
    }

    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        return this.getDescriptor();
    }

    @Override
    public StructDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    @Override
    public void setDescriptor(StructDescriptor desc) {
        this.descriptor = desc;
    }

    @Override
    public Datum[] getOracleAttributes() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            Datum[] datumArray = this.descriptor.toOracleArray(this, this, this.enableLocalCache);
            return datumArray;
        }
    }

    @Override
    public Map<String, Class<?>> getMap() {
        Map<String, Class<?>> ret = null;
        try {
            ret = this.getInternalConnection().getTypeMap();
        }
        catch (SQLException ex) {
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getMap", "Internal error. {0}", (String)null, (Throwable)null, (Object)ex.getMessage());
        }
        return ret;
    }

    @Override
    public byte[] toBytes() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            byte[] byArray = this.descriptor.toBytes(this, this, this.enableLocalCache);
            return byArray;
        }
    }

    @Override
    public void setDatumArray(Datum[] darray) {
        try {
            this.datumArray = darray == null ? new Datum[this.descriptor.getLength()] : darray;
        }
        catch (SQLException ea) {
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "setDatumArray", "getLength() threw an exception: {0}", (String)null, (Throwable)null, (Object)ea.getMessage());
        }
    }

    @Override
    public Datum[] getDatumArray() {
        return this.datumArray;
    }

    @Override
    public void setNullDatumArray() {
        this.datumArray = null;
    }

    @Override
    public Object[] getObjectArray() {
        return this.objectArray;
    }

    @Override
    public void setNullObjectArray() {
        this.objectArray = null;
    }

    @Override
    public void setObjArray(Object[] oarray) throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            this.objectArray = oarray == null ? new Object[]{} : oarray;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        Map<String, Class<?>> map = this.getMap();
        return this.toJdbc(map);
    }

    @Override
    public Object toJdbc(Map<String, Class<?>> map) throws SQLException {
        Class c;
        Object jdbcObject = this;
        if (map != null && (c = this.descriptor.getClass(map)) != null) {
            jdbcObject = this.toClass(c, map);
        }
        return jdbcObject;
    }

    @Override
    public <T> T toClass(Class<T> clazz) throws SQLException {
        return (T)this.toClass(clazz, this.getMap());
    }

    @Override
    public Object toClass(Class<?> clazz, Map<String, Class<?>> map) throws SQLException {
        Object obj;
        block8: {
            obj = null;
            try {
                if (clazz == null || clazz == STRUCT.class || clazz == Struct.class || clazz == oracle.jdbc.OracleStruct.class || clazz == oracle.jdbc.internal.OracleStruct.class) {
                    obj = this;
                    break block8;
                }
                Object i = clazz.newInstance();
                if (i instanceof SQLData) {
                    ((SQLData)i).readSQL(this.descriptor.toJdbc2SQLInput(this, this, map), this.descriptor.getName());
                    obj = i;
                    break block8;
                }
                if (i instanceof ORADataFactory) {
                    ORADataFactory f = (ORADataFactory)i;
                    obj = f.create(this, 2002);
                    break block8;
                }
                if (i instanceof OracleDataFactory) {
                    OracleDataFactory f = (OracleDataFactory)i;
                    obj = f.create(this, 2002);
                    break block8;
                }
                if (i instanceof CustomDatumFactory) {
                    CustomDatumFactory f = (CustomDatumFactory)i;
                    obj = f.create(this, 2002);
                    break block8;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName()).fillInStackTrace();
            }
            catch (InstantiationException ex) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + ex.getMessage()).fillInStackTrace();
            }
            catch (IllegalAccessException ex) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + ex.getMessage()).fillInStackTrace();
            }
        }
        return obj;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        return false;
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new Object[arraySize];
    }

    @Override
    public void setAutoBuffering(boolean enable) throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            this.enableLocalCache = enable;
        }
    }

    @Override
    public boolean getAutoBuffering() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            boolean bl = this.enableLocalCache;
            return bl;
        }
    }

    @Override
    public void setImage(byte[] image, long offset, long length) throws SQLException {
        this.setShareBytes(image);
        this.imageOffset = offset;
        this.imageLength = length;
    }

    @Override
    public void setImageLength(long length) throws SQLException {
        this.imageLength = length;
    }

    @Override
    public long getImageOffset() {
        return this.imageOffset;
    }

    @Override
    public long getImageLength() {
        return this.imageLength;
    }

    public CustomDatumFactory getFactory(Hashtable<?, ?> map, String classname) throws SQLException {
        String sqlTypeName = this.getSQLTypeName();
        Object factory = map.get(sqlTypeName);
        if (factory == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + sqlTypeName + "\" to a \"" + classname + "\" or a subclass of \"" + classname + "\"").fillInStackTrace();
        }
        return (CustomDatumFactory)factory;
    }

    @Override
    public ORADataFactory getORADataFactory(Hashtable<?, ?> map, String classname) throws SQLException {
        String sqlTypeName = this.getSQLTypeName();
        Object factory = map.get(sqlTypeName);
        if (factory == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + sqlTypeName + "\" to a \"" + classname + "\" or a subclass of \"" + classname + "\"").fillInStackTrace();
        }
        return (ORADataFactory)factory;
    }

    public OracleDataFactory getOracleDataFactory(Hashtable<?, ?> map, String classname) throws SQLException {
        String sqlTypeName = this.getSQLTypeName();
        Object factory = map.get(sqlTypeName);
        if (factory == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + sqlTypeName + "\" to a \"" + classname + "\" or a subclass of \"" + classname + "\"").fillInStackTrace();
        }
        return (OracleDataFactory)factory;
    }

    public String debugString() {
        StringWriter result = new StringWriter();
        String ret = null;
        try {
            StructDescriptor desc = this.getDescriptor();
            result.write("name = " + desc.getName());
            int length = desc.getLength();
            result.write(" length = " + length);
            Object[] attr = this.getAttributes();
            for (int i = 0; i < length; ++i) {
                result.write(" attribute[" + i + "] = " + attr[i]);
            }
            ret = result.toString();
        }
        catch (SQLException ex) {
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "debugString", "StructDescriptor missing or bad formatted.", null, null);
            ret = "StructDescriptor missing or bad";
        }
        return ret;
    }

    @Override
    public boolean isInHierarchyOf(String checkThisName) throws SQLException {
        return this.descriptor.isInHierarchyOf(checkThisName);
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

