/*
 * Decompiled with CFR 0.152.
 */
package j2html;

import j2html.utils.CSSMin;
import j2html.utils.EscapeUtil;
import j2html.utils.Indenter;
import j2html.utils.JSMin;
import j2html.utils.Minifier;
import j2html.utils.TextEscaper;
import java.util.Collections;

public class Config {
    public static TextEscaper textEscaper = EscapeUtil::escape;
    public static Minifier cssMinifier = CSSMin::compressCss;
    public static Minifier jsMinifier = JSMin::compressJs;
    public static boolean closeEmptyTags = false;
    private static String FOUR_SPACES = "    ";
    public static Indenter indenter = (level, text) -> String.join((CharSequence)"", Collections.nCopies(level, FOUR_SPACES)) + text;
    private TextEscaper _textEscaper;
    private Minifier _cssMinifier;
    private Minifier _jsMinifier;
    private boolean _closeEmptyTags;
    private Indenter _indenter;
    private static final Config DEFAULTS = new Config(EscapeUtil::escape, CSSMin::compressCss, JSMin::compressJs, false, (level, text) -> String.join((CharSequence)"", Collections.nCopies(level, FOUR_SPACES)) + text);

    private Config(TextEscaper _textEscaper, Minifier _cssMinifier, Minifier _jsMinifier, boolean _closeEmptyTags, Indenter _indenter) {
        this._textEscaper = _textEscaper;
        this._cssMinifier = _cssMinifier;
        this._jsMinifier = _jsMinifier;
        this._closeEmptyTags = _closeEmptyTags;
        this._indenter = _indenter;
    }

    private Config(Config original) {
        this._textEscaper = original._textEscaper;
        this._cssMinifier = original._cssMinifier;
        this._jsMinifier = original._jsMinifier;
        this._closeEmptyTags = original._closeEmptyTags;
        this._indenter = original._indenter;
    }

    public TextEscaper textEscaper() {
        return this._textEscaper;
    }

    public Minifier cssMinifier() {
        return this._cssMinifier;
    }

    public Minifier jsMinifier() {
        return this._jsMinifier;
    }

    public boolean closeEmptyTags() {
        return this._closeEmptyTags;
    }

    public Indenter indenter() {
        return this._indenter;
    }

    public Config withTextEscaper(TextEscaper textEscaper) {
        Config copy = new Config(this);
        copy._textEscaper = textEscaper;
        return copy;
    }

    public Config withCssMinifier(Minifier cssMinifier) {
        Config copy = new Config(this);
        copy._cssMinifier = cssMinifier;
        return copy;
    }

    public Config withJsMinifier(Minifier jsMinifier) {
        Config copy = new Config(this);
        copy._jsMinifier = jsMinifier;
        return copy;
    }

    public Config withEmptyTagsClosed(boolean closeEmptyTags) {
        Config copy = new Config(this);
        copy._closeEmptyTags = closeEmptyTags;
        return copy;
    }

    public Config withIndenter(Indenter indenter) {
        Config copy = new Config(this);
        copy._indenter = indenter;
        return copy;
    }

    public static final Config defaults() {
        return DEFAULTS;
    }

    public static final Config global() {
        return new Config(textEscaper, cssMinifier, jsMinifier, closeEmptyTags, indenter);
    }
}

