/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.fips;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.bouncycastle.jsse.util.CustomSSLSocketFactory;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.IPAddress;
import org.jboss.logging.Logger;
import org.keycloak.common.crypto.CertificateUtilsProvider;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.common.crypto.ECDSACryptoProvider;
import org.keycloak.common.crypto.PemUtilsProvider;
import org.keycloak.common.crypto.UserIdentityExtractorProvider;
import org.keycloak.common.util.BouncyIntegration;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.fips.AbstractDelegatingSSLSocket;
import org.keycloak.crypto.fips.BCFIPSCertificateUtilsProvider;
import org.keycloak.crypto.fips.BCFIPSECDSACryptoProvider;
import org.keycloak.crypto.fips.BCFIPSEcdhEsAlgorithmProvider;
import org.keycloak.crypto.fips.BCFIPSOCSPProvider;
import org.keycloak.crypto.fips.BCFIPSPemUtilsProvider;
import org.keycloak.crypto.fips.BCFIPSUserIdentityExtractorProvider;
import org.keycloak.crypto.fips.FIPSAesKeyWrapAlgorithmProvider;
import org.keycloak.crypto.fips.FIPSRsaKeyEncryptionJWEAlgorithmProvider;

public class FIPS1402Provider
implements CryptoProvider {
    private static final Logger log = Logger.getLogger(FIPS1402Provider.class);
    private final BouncyCastleFipsProvider bcFipsProvider;
    private final Map<String, Object> providers = new ConcurrentHashMap<String, Object>();

    public FIPS1402Provider() {
        BouncyCastleFipsProvider existingBcFipsProvider = (BouncyCastleFipsProvider)Security.getProvider("BCFIPS");
        this.bcFipsProvider = existingBcFipsProvider == null ? new BouncyCastleFipsProvider() : existingBcFipsProvider;
        this.providers.put("A128KW", new FIPSAesKeyWrapAlgorithmProvider());
        this.providers.put("RSA1_5", new FIPSRsaKeyEncryptionJWEAlgorithmProvider((FipsRSA.WrapParameters)FipsRSA.WRAP_PKCS1v1_5));
        this.providers.put("RSA-OAEP", new FIPSRsaKeyEncryptionJWEAlgorithmProvider((FipsRSA.WrapParameters)FipsRSA.WRAP_OAEP));
        this.providers.put("RSA-OAEP-256", new FIPSRsaKeyEncryptionJWEAlgorithmProvider((FipsRSA.WrapParameters)FipsRSA.WRAP_OAEP.withDigest(FipsSHS.Algorithm.SHA256)));
        this.providers.put("ECDH-ES", new BCFIPSEcdhEsAlgorithmProvider());
        this.providers.put("ECDH-ES+A128KW", new BCFIPSEcdhEsAlgorithmProvider());
        this.providers.put("ECDH-ES+A192KW", new BCFIPSEcdhEsAlgorithmProvider());
        this.providers.put("ECDH-ES+A256KW", new BCFIPSEcdhEsAlgorithmProvider());
        if (existingBcFipsProvider == null) {
            this.checkSecureRandom(() -> Security.insertProviderAt((Provider)this.bcFipsProvider, 1));
            BouncyCastleJsseProvider bcJsseProvider = new BouncyCastleJsseProvider("fips:BCFIPS");
            Security.insertProviderAt((Provider)bcJsseProvider, 2);
            FIPS1402Provider.modifyKeyTrustManagerSecurityProperties((Provider)bcJsseProvider);
            log.debugf("Inserted security providers: %s", Arrays.asList(this.bcFipsProvider.getName(), bcJsseProvider.getName()));
        } else {
            log.debugf("Security provider %s already loaded", (Object)existingBcFipsProvider.getName());
        }
        log.infof("FIPS1402Provider created: KC(%s%s, FIPS-JVM: %s)", (Object)this.bcFipsProvider, (Object)(CryptoServicesRegistrar.isInApprovedOnlyMode() ? " Approved Mode" : ""), (Object)FIPS1402Provider.isSystemFipsEnabled());
    }

    public Provider getBouncyCastleProvider() {
        return this.bcFipsProvider;
    }

    public int order() {
        return 200;
    }

    public <T> T getAlgorithmProvider(Class<T> clazz, String algorithm) {
        Object o = this.providers.get(algorithm);
        if (o == null) {
            throw new IllegalArgumentException("Not found provider of algorithm: " + algorithm);
        }
        return clazz.cast(o);
    }

    public CertificateUtilsProvider getCertificateUtils() {
        return new BCFIPSCertificateUtilsProvider();
    }

    public PemUtilsProvider getPemUtils() {
        return new BCFIPSPemUtilsProvider();
    }

    public ECParameterSpec createECParams(String curveName) {
        ECField field;
        X9ECParameters params = ECNamedCurveTable.getByName((String)curveName);
        ECCurve ecCurve = params.getCurve();
        if (ecCurve instanceof ECCurve.F2m) {
            ECCurve.F2m f2m = (ECCurve.F2m)ecCurve;
            field = new ECFieldF2m(f2m.getM(), new int[]{f2m.getK1(), f2m.getK2(), f2m.getK3()});
        } else if (ecCurve instanceof ECCurve.Fp) {
            ECCurve.Fp fp = (ECCurve.Fp)ecCurve;
            field = new ECFieldFp(fp.getQ());
        } else {
            throw new RuntimeException("Unsupported curve");
        }
        EllipticCurve c = new EllipticCurve(field, ecCurve.getA().toBigInteger(), ecCurve.getB().toBigInteger(), params.getSeed());
        ECPoint point = new ECPoint(params.getG().getXCoord().toBigInteger(), params.getG().getYCoord().toBigInteger());
        return new ECParameterSpec(c, point, params.getN(), params.getH().intValue());
    }

    public UserIdentityExtractorProvider getIdentityExtractorProvider() {
        return new BCFIPSUserIdentityExtractorProvider();
    }

    public ECDSACryptoProvider getEcdsaCryptoProvider() {
        return new BCFIPSECDSACryptoProvider();
    }

    public <T> T getOCSPProver(Class<T> clazz) {
        return clazz.cast((Object)new BCFIPSOCSPProvider());
    }

    public KeyPairGenerator getKeyPairGen(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyPairGenerator.getInstance(algorithm, BouncyIntegration.PROVIDER);
    }

    public KeyFactory getKeyFactory(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyFactory.getInstance(algorithm, BouncyIntegration.PROVIDER);
    }

    public Cipher getAesCbcCipher() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        return Cipher.getInstance("AES/CBC/PKCS7Padding", BouncyIntegration.PROVIDER);
    }

    public Cipher getAesGcmCipher() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        return Cipher.getInstance("AES/GCM/NoPadding", BouncyIntegration.PROVIDER);
    }

    public SecretKeyFactory getSecretKeyFact(String keyAlgorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return SecretKeyFactory.getInstance(keyAlgorithm, BouncyIntegration.PROVIDER);
    }

    public KeyStore getKeyStore(KeystoreUtil.KeystoreFormat format) throws KeyStoreException, NoSuchProviderException {
        return KeyStore.getInstance(format.toString(), BouncyIntegration.PROVIDER);
    }

    public CertificateFactory getX509CertFactory() throws CertificateException, NoSuchProviderException {
        return CertificateFactory.getInstance("X.509", BouncyIntegration.PROVIDER);
    }

    public CertStore getCertStore(CollectionCertStoreParameters certStoreParams) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        return CertStore.getInstance("Collection", (CertStoreParameters)certStoreParams, BouncyIntegration.PROVIDER);
    }

    public CertPathBuilder getCertPathBuilder() throws NoSuchAlgorithmException, NoSuchProviderException {
        return CertPathBuilder.getInstance("PKIX", BouncyIntegration.PROVIDER);
    }

    public Signature getSignature(String sigAlgName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return Signature.getInstance(JavaAlgorithm.getJavaAlgorithm((String)sigAlgName), BouncyIntegration.PROVIDER);
    }

    public SSLSocketFactory wrapFactoryForTruststore(SSLSocketFactory delegate) {
        return new CustomSSLSocketFactory(delegate){

            public Socket createSocket() throws IOException {
                Socket socket = this.delegate.createSocket();
                if (socket instanceof SSLSocket) {
                    return new AbstractDelegatingSSLSocket((SSLSocket)socket){

                        @Override
                        public void connect(SocketAddress endpoint) throws IOException {
                            log.tracef("Calling connect(%s)", (Object)endpoint);
                            if (endpoint instanceof InetSocketAddress) {
                                this.configureSocket(this.getDelegate(), ((InetSocketAddress)endpoint).getHostName());
                            }
                            super.connect(endpoint);
                        }

                        @Override
                        public void connect(SocketAddress endpoint, int timeout) throws IOException {
                            log.tracef("Calling connect(%s, %d)", (Object)endpoint, (Object)timeout);
                            if (endpoint instanceof InetSocketAddress) {
                                this.configureSocket(this.getDelegate(), ((InetSocketAddress)endpoint).getHostName());
                            }
                            super.connect(endpoint, timeout);
                        }
                    };
                }
                return socket;
            }

            public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
                return this.configureSocket(this.delegate.createSocket(host, port), host);
            }

            public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
                return this.configureSocket(this.delegate.createSocket(host, port, localHost, localPort), host);
            }

            protected Socket configureSocket(Socket s) {
                if (s instanceof SSLSocket) {
                    if (s.getInetAddress() == null) {
                        throw new IllegalArgumentException("Socket not connected before trying to configure SSL Hostname");
                    }
                    String hostname = s.getInetAddress().getHostName();
                    this.configureSocket(s, hostname);
                }
                return s;
            }

            private Socket configureSocket(Socket s, String hostname) {
                if (s instanceof SSLSocket) {
                    SSLSocket ssl = (SSLSocket)s;
                    SNIHostName sniHostname = this.getSNIHostName(hostname);
                    log.tracef("Configuration of SSL Socket - using sniHostname '%s' for the socket host '%s'", (Object)sniHostname, (Object)hostname);
                    if (sniHostname != null) {
                        SSLParameters sslParameters = ssl.getSSLParameters();
                        if (sslParameters == null) {
                            sslParameters = new SSLParameters();
                        }
                        sslParameters.setServerNames(Collections.singletonList(sniHostname));
                        ssl.setSSLParameters(sslParameters);
                    }
                }
                return s;
            }

            private SNIHostName getSNIHostName(String host) {
                if (!IPAddress.isValid((String)host)) {
                    try {
                        return new SNIHostName(host);
                    }
                    catch (RuntimeException e) {
                        log.warnf((Throwable)e, "Not possible to create SNIHostName from the host '%s'", (Object)host);
                    }
                }
                return null;
            }
        };
    }

    private void checkSecureRandom(Runnable insertBcFipsProvider) {
        try {
            SecureRandom sr = SecureRandom.getInstanceStrong();
            log.debugf("Strong secure random available. Algorithm: %s, Provider: %s", (Object)sr.getAlgorithm(), (Object)sr.getProvider());
            insertBcFipsProvider.run();
        }
        catch (NoSuchAlgorithmException nsae) {
            SecureRandom secRandom = new SecureRandom();
            String origStrongAlgs = Security.getProperty("securerandom.strongAlgorithms");
            String usedAlg = secRandom.getAlgorithm() + ":" + secRandom.getProvider().getName();
            log.debugf("Strong secure random not available. Tried algorithms: %s. Using algorithm as a fallback for strong secure random: %s", (Object)origStrongAlgs, (Object)usedAlg);
            Security.setProperty("securerandom.strongAlgorithms", usedAlg);
            try {
                insertBcFipsProvider.run();
                SecureRandom.getInstance("DEFAULT", "BCFIPS");
                log.debugf("Initialized BCFIPS secured random", new Object[0]);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException nsaee) {
                throw new IllegalStateException("Not possible to initiate BCFIPS secure random", nsaee);
            }
        }
    }

    private static void modifyKeyTrustManagerSecurityProperties(Provider bcJsseProvider) {
        boolean setTrust;
        boolean setKey = bcJsseProvider.getService(KeyManagerFactory.class.getSimpleName(), KeyManagerFactory.getDefaultAlgorithm()) == null;
        boolean bl = setTrust = bcJsseProvider.getService(TrustManagerFactory.class.getSimpleName(), TrustManagerFactory.getDefaultAlgorithm()) == null;
        if (!setKey && !setTrust) {
            return;
        }
        Set<Provider.Service> services = bcJsseProvider.getServices();
        if (services != null) {
            for (Provider.Service service : services) {
                if (setKey && KeyManagerFactory.class.getSimpleName().equals(service.getType())) {
                    Security.setProperty("ssl.KeyManagerFactory.algorithm", service.getAlgorithm());
                    setKey = false;
                    if (setTrust) continue;
                    return;
                }
                if (!setTrust || !TrustManagerFactory.class.getSimpleName().equals(service.getType())) continue;
                Security.setProperty("ssl.TrustManagerFactory.algorithm", service.getAlgorithm());
                setTrust = false;
                if (setKey) continue;
                return;
            }
        }
        throw new IllegalStateException("Provider " + bcJsseProvider.getName() + " does not provide KeyManagerFactory or TrustManagerFactory algorithms for TLS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String isSystemFipsEnabled() {
        Method isSystemFipsEnabled = null;
        try {
            Class<?> securityConfigurator = FIPS1402Provider.class.getClassLoader().loadClass("java.security.SystemConfigurator");
            isSystemFipsEnabled = securityConfigurator.getDeclaredMethod("isSystemFipsEnabled", new Class[0]);
            isSystemFipsEnabled.setAccessible(true);
            boolean isEnabled = (Boolean)isSystemFipsEnabled.invoke(null, new Object[0]);
            String string = isEnabled ? "enabled" : "disabled";
            return string;
        }
        catch (Throwable ignore) {
            log.debug((Object)"Could not detect if FIPS is enabled from the host", ignore);
            String string = "unknown";
            return string;
        }
        finally {
            if (isSystemFipsEnabled != null) {
                isSystemFipsEnabled.setAccessible(false);
            }
        }
    }
}

