/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.api.BasicCache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.session.RevokedTokenPersisterProvider;
import org.keycloak.models.sessions.infinispan.InfinispanKeycloakTransaction;
import org.keycloak.models.sessions.infinispan.entities.SingleUseObjectValueEntity;

public class InfinispanSingleUseObjectProvider
implements SingleUseObjectProvider {
    private final KeycloakSession session;
    private final BasicCache<String, SingleUseObjectValueEntity> singleUseObjectCache;
    private final boolean persistRevokedTokens;
    private final InfinispanKeycloakTransaction tx;

    public InfinispanSingleUseObjectProvider(KeycloakSession session, BasicCache<String, SingleUseObjectValueEntity> singleUseObjectCache, boolean persistRevokedTokens, InfinispanKeycloakTransaction tx) {
        this.session = session;
        this.singleUseObjectCache = singleUseObjectCache;
        this.persistRevokedTokens = persistRevokedTokens;
        this.tx = tx;
    }

    public void put(String key, long lifespanSeconds, Map<String, String> notes) {
        SingleUseObjectValueEntity tokenValue = new SingleUseObjectValueEntity(notes);
        this.tx.put(this.singleUseObjectCache, key, tokenValue, lifespanSeconds, TimeUnit.SECONDS);
        if (this.persistRevokedTokens && key.endsWith(".revoked")) {
            if (!notes.isEmpty()) {
                throw new ModelException("Notes are not supported for revoked tokens");
            }
            ((RevokedTokenPersisterProvider)this.session.getProvider(RevokedTokenPersisterProvider.class)).revokeToken(key.substring(0, key.length() - ".revoked".length()), lifespanSeconds);
        }
    }

    public Map<String, String> get(String key) {
        if (this.persistRevokedTokens && key.endsWith(".revoked")) {
            throw new ModelException("Revoked tokens can't be retrieved");
        }
        SingleUseObjectValueEntity singleUseObjectValueEntity = this.tx.get(this.singleUseObjectCache, key);
        return singleUseObjectValueEntity != null ? singleUseObjectValueEntity.getNotes() : null;
    }

    public Map<String, String> remove(String key) {
        if (this.persistRevokedTokens && key.endsWith(".revoked")) {
            throw new ModelException("Revoked tokens can't be removed");
        }
        SingleUseObjectValueEntity data = (SingleUseObjectValueEntity)this.singleUseObjectCache.get((Object)key);
        if (data == null) {
            return null;
        }
        return this.singleUseObjectCache.remove((Object)key, (Object)data) ? data.getNotes() : null;
    }

    public boolean replace(String key, Map<String, String> notes) {
        if (this.persistRevokedTokens && key.endsWith(".revoked")) {
            throw new ModelException("Revoked tokens can't be replaced");
        }
        return this.singleUseObjectCache.replace((Object)key, (Object)new SingleUseObjectValueEntity(notes)) != null;
    }

    public boolean putIfAbsent(String key, long lifespanInSeconds) {
        if (this.persistRevokedTokens && key.endsWith(".revoked")) {
            throw new ModelException("Revoked tokens can't be used in putIfAbsent");
        }
        SingleUseObjectValueEntity tokenValue = new SingleUseObjectValueEntity(null);
        return this.singleUseObjectCache.putIfAbsent((Object)key, (Object)tokenValue, lifespanInSeconds, TimeUnit.SECONDS) == null;
    }

    public boolean contains(String key) {
        return this.singleUseObjectCache.containsKey((Object)key);
    }

    public void close() {
    }
}

