/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.juife.OkCancelDialog;
import org.jsampler.CC;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;

public class JSamplerHomeChooser
extends OkCancelDialog {
    private static final JTextField tfHome = new JTextField();
    private final JButton btnBrowse = new JButton(StdI18n.i18n.getButtonLabel("browse"));

    public JSamplerHomeChooser(Frame frame) {
        super(frame, StdI18n.i18n.getLabel("JSamplerHomeChooser.title"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        Dimension dimension = new Dimension(Short.MAX_VALUE, JSamplerHomeChooser.tfHome.getPreferredSize().height);
        tfHome.setMaximumSize(dimension);
        jPanel.add(tfHome);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel.add(this.btnBrowse);
        jPanel.setPreferredSize(new Dimension(350, jPanel.getPreferredSize().height));
        this.setMainPane(jPanel);
        if (CC.getJSamplerHome() != null) {
            tfHome.setText(CC.getJSamplerHome());
        } else {
            tfHome.setText(System.getProperty("user.home") + File.separator + ".jsampler");
        }
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSamplerHomeChooser.this.onBrowse();
            }
        });
        this.btnBrowse.requestFocusInWindow();
        this.setResizable(true);
    }

    private void onBrowse() {
        File file = StdUtils.showOpenDirectoryChooser(this, null);
        if (file == null) {
            return;
        }
        tfHome.setText(file.getPath() + File.separator + ".jsampler");
        this.btnOk.requestFocusInWindow();
    }

    @Override
    protected void onOk() {
        if (tfHome.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, StdI18n.i18n.getLabel("JSamplerHomeChooser.selectFile"), "", 1);
            return;
        }
        this.setVisible(false);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    public String getJSamplerHome() {
        return tfHome.getText();
    }
}

