/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FocusManager;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.TabWindowMover;
import net.infonode.docking.View;
import net.infonode.docking.WindowDecoder;
import net.infonode.docking.WindowTab;
import net.infonode.docking.drop.InsertTabDropInfo;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WindowAncestors;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.model.AbstractTabWindowItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowItem;
import net.infonode.docking.properties.TabWindowProperties;
import net.infonode.docking.properties.WindowTabProperties;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabContentPanel;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.util.ChangeNotifyList;

public abstract class AbstractTabWindow
extends DockingWindow {
    private static int MINIMUM_SIZE = 7;
    private final DropAction dropAction = new DropAction(){

        @Override
        public boolean showTitle() {
            return false;
        }

        @Override
        public void execute(DockingWindow window, MouseEvent mouseEvent) {
            if (window.getWindowParent() == AbstractTabWindow.this) {
                AbstractTabWindow.this.updateWindowItem(window);
            } else {
                int index = AbstractTabWindow.this.tabbedPanel.getTabIndex(AbstractTabWindow.this.dragTab);
                AbstractTabWindow.this.stopDrag();
                try {
                    window.beforeDrop(AbstractTabWindow.this);
                    if (mouseEvent.isShiftDown()) {
                        AbstractTabWindow.this.addTabNoSelect(window, index);
                    } else {
                        AbstractTabWindow.this.addTab(window, index);
                    }
                }
                catch (OperationAbortedException operationAbortedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void clear(DockingWindow window, DropAction newDropAction) {
            if (newDropAction != this) {
                if (window.getWindowParent() == AbstractTabWindow.this) {
                    WindowTab tab = window.getTab();
                    boolean selected = tab.isSelected();
                    AbstractTabWindow.this.tabbedPanel.removeTab(tab);
                    AbstractTabWindow.this.tabbedPanel.insertTab((Tab)tab, AbstractTabWindow.this.draggedTabIndex);
                    if (selected) {
                        tab.setSelected(true);
                    }
                } else {
                    AbstractTabWindow.this.stopDrag();
                }
            }
        }
    };
    private TabbedPanel tabbedPanel;
    private WindowTab dragTab;
    private int ignoreSelected;
    private int draggedTabIndex;
    private List tabAreaComponents;

    public abstract TabWindowProperties getTabWindowProperties();

    protected AbstractTabWindow(boolean showContent, WindowItem windowItem) {
        super(windowItem);
        if (showContent) {
            TabContentPanel contentPanel = new TabContentPanel(){

                @Override
                public Dimension getMinimumSize() {
                    if (AbstractTabWindow.this.getTabWindowProperties().getRespectChildWindowMinimumSize()) {
                        return super.getMinimumSize();
                    }
                    return new Dimension(0, 0);
                }
            };
            this.tabbedPanel = new TabbedPanel(contentPanel, true){

                @Override
                public Dimension getMinimumSize() {
                    if (AbstractTabWindow.this.getTabWindowProperties().getRespectChildWindowMinimumSize()) {
                        return super.getMinimumSize();
                    }
                    return AbstractTabWindow.this.getTabbedPanelMinimumSize(super.getMinimumSize());
                }
            };
            contentPanel.setTabbedPanel(this.tabbedPanel);
        } else {
            this.tabbedPanel = new TabbedPanel(null){

                @Override
                public Dimension getMinimumSize() {
                    if (AbstractTabWindow.this.getTabWindowProperties().getRespectChildWindowMinimumSize()) {
                        return super.getMinimumSize();
                    }
                    return AbstractTabWindow.this.getTabbedPanelMinimumSize(super.getMinimumSize());
                }
            };
        }
        this.tabbedPanel.addTabListener(new TabWindowMover(this, this.tabbedPanel));
        this.setComponent(this.tabbedPanel);
        this.getTabbedPanel().addTabListener(new TabAdapter(){

            @Override
            public void tabAdded(TabEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTabWindow.this.updateButtonVisibility();
                    }
                });
            }

            @Override
            public void tabRemoved(TabRemovedEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTabWindow.this.updateButtonVisibility();
                    }
                });
            }

            @Override
            public void tabSelected(TabStateChangedEvent event) {
                AbstractTabWindow.this.tabSelected((WindowTab)event.getTab());
                DockingWindow selectedWindow = AbstractTabWindow.this.getSelectedWindow();
                if (!AbstractTabWindow.this.getIgnoreSelected() && selectedWindow != null) {
                    selectedWindow.fireWindowShown(selectedWindow);
                }
            }

            @Override
            public void tabDeselected(TabStateChangedEvent event) {
                WindowTab tab = (WindowTab)event.getTab();
                if (tab != null && !AbstractTabWindow.this.getIgnoreSelected()) {
                    tab.getWindow().fireWindowHidden(tab.getWindow());
                }
            }

            @Override
            public void tabMoved(TabEvent event) {
                if (!AbstractTabWindow.this.getIgnoreSelected()) {
                    AbstractTabWindow.this.fireTitleChanged();
                }
            }
        });
    }

    protected void initMouseListener() {
        this.getTabbedPanel().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AbstractTabWindow.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mousePressed(e);
            }
        });
    }

    private Dimension getTabbedPanelMinimumSize(Dimension d) {
        if (this.tabbedPanel.getProperties().getTabAreaOrientation().isHorizontal()) {
            return new Dimension(d.width, MINIMUM_SIZE);
        }
        return new Dimension(MINIMUM_SIZE, d.height);
    }

    public final List getCustomTabAreaComponents() {
        if (this.tabAreaComponents == null) {
            this.tabAreaComponents = new ChangeNotifyList(){

                @Override
                protected void changed() {
                    AbstractTabWindow.this.updateTabAreaComponents();
                }
            };
        }
        return this.tabAreaComponents;
    }

    public DockingWindow getSelectedWindow() {
        WindowTab tab = (WindowTab)this.tabbedPanel.getSelectedTab();
        return tab == null ? null : tab.getWindow();
    }

    public void setSelectedTab(int index) {
        this.beginIgnoreSelected();
        try {
            Tab tab = index == -1 ? null : this.tabbedPanel.getTabAt(index);
            Tab oldTab = this.tabbedPanel.getSelectedTab();
            if (tab != oldTab) {
                this.tabbedPanel.setSelectedTab(tab);
                this.fireTitleChanged();
                if (oldTab != null) {
                    ((WindowTab)oldTab).getWindow().fireWindowHidden(((WindowTab)oldTab).getWindow());
                }
                if (tab != null) {
                    ((WindowTab)tab).getWindow().fireWindowShown(((WindowTab)tab).getWindow());
                }
            }
        }
        finally {
            this.endIgnoreSelected();
        }
    }

    public void addTab(DockingWindow window) {
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.addTab(window, this.tabbedPanel.getTabCount());
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    public int addTab(DockingWindow window, int index) {
        PropertyMapManager.getInstance().beginBatch();
        try {
            int n = this.addTabNoSelect(window, index);
            return n;
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    protected int addTabNoSelect(DockingWindow window, int index) {
        WindowAncestors ancestors = window.storeAncestors();
        AbstractTabWindow.beginOptimize(window.getWindowParent());
        this.beginIgnoreSelected();
        try {
            Tab beforeTab = index >= this.tabbedPanel.getTabCount() ? null : this.tabbedPanel.getTabAt(index);
            DockingWindow w = window.getContentWindow(this);
            w.detach();
            this.updateTab(w);
            WindowTab tab = w.getTab();
            int actualIndex = beforeTab == null ? this.tabbedPanel.getTabCount() : this.tabbedPanel.getTabIndex(beforeTab);
            this.tabbedPanel.insertTab((Tab)tab, actualIndex);
            this.addWindow(w);
            window.notifyListeners(ancestors);
            int n = actualIndex;
            return n;
        }
        finally {
            this.endIgnoreSelected();
            AbstractTabWindow.endOptimize();
        }
    }

    @Override
    protected boolean isChildShowingInRootWindow(DockingWindow child) {
        return super.isChildShowingInRootWindow(child) && child == this.getSelectedWindow();
    }

    @Override
    protected void showChildWindow(DockingWindow window) {
        this.setSelectedTab(this.getChildWindowIndex(window));
        super.showChildWindow(window);
    }

    @Override
    protected boolean childInsideTab() {
        return true;
    }

    protected void setTabWindowProperties(TabWindowProperties properties) {
        this.getTabbedPanel().getProperties().addSuperObject(properties.getTabbedPanelProperties());
    }

    @Override
    protected void clearFocus(View view) {
        if (this.getSelectedWindow() != null) {
            this.getSelectedWindow().clearFocus(view);
        }
    }

    @Override
    protected DockingWindow getPreferredFocusChild() {
        return this.getSelectedWindow() == null ? super.getPreferredFocusChild() : this.getSelectedWindow();
    }

    @Override
    protected void clearChildrenFocus(DockingWindow child, View view) {
        if (this.getSelectedWindow() != child) {
            this.clearFocus(view);
        }
    }

    protected int getTabAreaComponentCount() {
        return 0;
    }

    protected void updateTabAreaComponents() {
        int ls = this.tabAreaComponents == null ? 0 : this.tabAreaComponents.size();
        JComponent[] components = new JComponent[ls + this.getTabAreaComponentCount()];
        if (this.tabAreaComponents != null) {
            this.tabAreaComponents.toArray(components);
        }
        this.getTabAreaComponents(ls, components);
        this.getTabbedPanel().setTabAreaComponents(components);
    }

    protected void getTabAreaComponents(int index, JComponent[] components) {
    }

    protected final boolean getIgnoreSelected() {
        return this.ignoreSelected > 0;
    }

    protected void tabSelected(WindowTab tab) {
        RootWindow root;
        if (!this.getIgnoreSelected() && tab != null && (root = this.getRootWindow()) != null) {
            tab.setFocused(true);
            root.addFocusedWindow(tab.getWindow());
            FocusManager.focusWindow(tab.getWindow());
        }
        if (!this.getIgnoreSelected()) {
            this.fireTitleChanged();
        }
    }

    protected TabbedPanel getTabbedPanel() {
        return this.tabbedPanel;
    }

    @Override
    public DockingWindow getChildWindow(int index) {
        return ((WindowTab)this.tabbedPanel.getTabAt(index)).getWindow();
    }

    @Override
    protected DockingWindow getLocationWindow() {
        return this.tabbedPanel.getTabCount() == 1 ? this.getChildWindow(0) : this;
    }

    @Override
    public int getChildWindowCount() {
        return this.tabbedPanel.getTabCount();
    }

    @Override
    public Icon getIcon() {
        DockingWindow window = this.getSelectedWindow();
        return window != null ? window.getIcon() : (this.getChildWindowCount() > 0 ? this.getChildWindow(0).getIcon() : null);
    }

    private void updateTab(DockingWindow window) {
        window.getTab().setProperties(this.getTabProperties(window));
    }

    private WindowTabProperties getTabProperties(DockingWindow window) {
        WindowTabProperties properties = new WindowTabProperties(this.getTabWindowProperties().getTabProperties());
        properties.addSuperObject(window.getWindowProperties().getTabProperties());
        return properties;
    }

    @Override
    protected void doReplace(DockingWindow oldWindow, DockingWindow newWindow) {
        this.beginIgnoreSelected();
        try {
            WindowTab tab = oldWindow.getTab();
            int tabIndex = this.tabbedPanel.getTabIndex(tab);
            boolean selected = tab.isSelected();
            this.tabbedPanel.removeTab(tab);
            this.tabbedPanel.insertTab((Tab)newWindow.getTab(), tabIndex);
            if (selected) {
                this.tabbedPanel.setSelectedTab(newWindow.getTab());
            }
            this.updateTab(newWindow);
        }
        finally {
            this.endIgnoreSelected();
        }
    }

    @Override
    protected void doRemoveWindow(DockingWindow window) {
        this.beginIgnoreSelected();
        try {
            WindowTab tab = window.getTab();
            tab.unsetProperties();
            this.tabbedPanel.removeTab(tab);
        }
        finally {
            this.endIgnoreSelected();
        }
    }

    private void beginIgnoreSelected() {
        ++this.ignoreSelected;
    }

    private void endIgnoreSelected() {
        --this.ignoreSelected;
    }

    protected boolean isInsideTabArea(Point p2) {
        return this.tabbedPanel.tabAreaContainsPoint(p2);
    }

    @Override
    protected DropAction acceptInteriorDrop(Point p, DockingWindow window) {
        if (this.getChildWindowCount() == 1 && window == this.getChildWindow(0) && this.dragTab == null) {
            return null;
        }
        Point p2 = SwingUtilities.convertPoint(this, p, this.tabbedPanel);
        if ((this.getRootWindow().getRootWindowProperties().getRecursiveTabsEnabled() || window.getChildWindowCount() <= 1) && this.isInsideTabArea(p2)) {
            this.getRootWindow().setDragRectangle(null);
            if (window.getWindowParent() == this) {
                this.tabbedPanel.moveTab(window.getTab(), p2);
            } else {
                if (!this.getInsertTabDropFilter().acceptDrop(new InsertTabDropInfo(window, this, p))) {
                    return null;
                }
                if (this.dragTab == null) {
                    this.dragTab = this.createGhostTab(window);
                    this.tabbedPanel.insertTab((Tab)this.dragTab, p2);
                } else {
                    this.tabbedPanel.moveTab(this.dragTab, p2);
                }
            }
            return this.dropAction;
        }
        return null;
    }

    WindowTab createGhostTab(DockingWindow window) {
        WindowTab tab = new WindowTab(window, true);
        tab.setProperties(this.getTabProperties(window));
        return tab;
    }

    private void stopDrag() {
        if (this.dragTab != null) {
            this.tabbedPanel.removeTab(this.dragTab);
            this.dragTab = null;
        }
    }

    @Override
    protected boolean showsWindowTitle() {
        return true;
    }

    @Override
    protected DockingWindow oldRead(ObjectInputStream in, ReadContext context) throws IOException {
        int size = in.readInt();
        int selectedIndex = in.readInt();
        while (this.getChildWindowCount() > 0) {
            this.removeChildWindow(this.getChildWindow(0));
        }
        int i = 0;
        while (i < size) {
            DockingWindow window = WindowDecoder.decodeWindow(in, context);
            if (window != null) {
                this.addTab(window);
            } else if (i < selectedIndex) {
                --selectedIndex;
            }
            ++i;
        }
        super.oldRead(in, context);
        if (this.tabbedPanel.getTabCount() > 0) {
            if (selectedIndex >= 0) {
                this.setSelectedTab(Math.min(this.tabbedPanel.getTabCount() - 1, selectedIndex));
            }
            return this;
        }
        return null;
    }

    @Override
    protected void write(ObjectOutputStream out, WriteContext context, ViewWriter viewWriter) throws IOException {
        out.writeInt(this.getChildWindowCount());
        int i = 0;
        while (i < this.getChildWindowCount()) {
            this.getChildWindow(i).write(out, context, viewWriter);
            ++i;
        }
    }

    protected DockingWindow newRead(ObjectInputStream in, ReadContext context, ViewReader viewReader) throws IOException {
        int size = in.readInt();
        while (this.getChildWindowCount() > 0) {
            this.removeChildWindow(this.getChildWindow(0));
        }
        int i = 0;
        while (i < size) {
            DockingWindow window = WindowDecoder.decodeWindow(in, context, viewReader);
            if (window != null) {
                this.addTab(window);
            }
            ++i;
        }
        this.updateSelectedTab();
        return this.getChildWindowCount() > 0 ? this : null;
    }

    protected void updateSelectedTab() {
        WindowItem selectedItem = ((AbstractTabWindowItem)this.getWindowItem()).getSelectedItem();
        int i = 0;
        while (i < this.getChildWindowCount()) {
            if (this.getChildWindow(i).getWindowItem().hasAncestor(selectedItem)) {
                this.setSelectedTab(i);
                return;
            }
            ++i;
        }
    }

    void setDraggedTabIndex(int index) {
        this.draggedTabIndex = index;
    }

    @Override
    void removeWindowComponent(DockingWindow window) {
        window.getTab().setContentComponent(null);
    }

    @Override
    void restoreWindowComponent(DockingWindow window) {
        window.getTab().setContentComponent(window);
    }
}

