/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog;

import java.io.Closeable;
import java.util.Map;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.get.GetResult;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.compliance.ComplianceConfig;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportRequest;

public interface AuditLog
extends Closeable {
    public void logFailedLogin(String var1, boolean var2, String var3, SecurityRequest var4);

    public void logSucceededLogin(String var1, boolean var2, String var3, SecurityRequest var4);

    public void logMissingPrivileges(String var1, String var2, SecurityRequest var3);

    public void logGrantedPrivileges(String var1, SecurityRequest var2);

    public void logMissingPrivileges(String var1, TransportRequest var2, Task var3);

    public void logGrantedPrivileges(String var1, TransportRequest var2, Task var3);

    public void logIndexEvent(String var1, TransportRequest var2, Task var3);

    public void logBadHeaders(TransportRequest var1, String var2, Task var3);

    public void logBadHeaders(SecurityRequest var1);

    public void logSecurityIndexAttempt(TransportRequest var1, String var2, Task var3);

    public void logSSLException(TransportRequest var1, Throwable var2, String var3, Task var4);

    public void logSSLException(SecurityRequest var1, Throwable var2);

    public void logDocumentRead(String var1, String var2, ShardId var3, Map<String, String> var4);

    public void logDocumentWritten(ShardId var1, GetResult var2, Engine.Index var3, Engine.IndexResult var4);

    public void logDocumentDeleted(ShardId var1, Engine.Delete var2, Engine.DeleteResult var3, GetResult var4);

    public ComplianceConfig getComplianceConfig();

    public void setConfig(AuditConfig var1);

    public static enum Operation {
        CREATE,
        UPDATE,
        DELETE;

    }

    public static enum Origin {
        REST,
        TRANSPORT,
        LOCAL,
        GRPC;

    }
}

