/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.type;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.sql.data.type.ExprType;

public enum ExprCoreType implements ExprType
{
    UNKNOWN(new ExprCoreType[0]),
    UNDEFINED(new ExprCoreType[0]),
    BYTE(UNDEFINED),
    SHORT(BYTE),
    INTEGER(SHORT),
    LONG(INTEGER),
    FLOAT(LONG),
    DOUBLE(FLOAT),
    STRING(UNDEFINED),
    BOOLEAN(STRING),
    DATE(STRING),
    TIME(STRING),
    TIMESTAMP(STRING, DATE, TIME),
    INTERVAL(UNDEFINED),
    IP(STRING),
    GEO_POINT(UNDEFINED),
    BINARY(UNDEFINED),
    STRUCT(UNDEFINED),
    ARRAY(UNDEFINED);

    private final List<ExprType> parents = new ArrayList<ExprType>();
    private static final Map<ExprCoreType, String> LEGACY_TYPE_NAME_MAPPING;
    private static final Set<ExprType> NUMBER_TYPES;

    private ExprCoreType(ExprCoreType ... compatibleTypes) {
        for (ExprCoreType subType : compatibleTypes) {
            subType.parents.add(this);
        }
    }

    @Override
    public List<ExprType> getParent() {
        return this.parents.isEmpty() ? ExprType.super.getParent() : this.parents;
    }

    @Override
    public String typeName() {
        return this.name();
    }

    @Override
    public String legacyTypeName() {
        return LEGACY_TYPE_NAME_MAPPING.getOrDefault(this, this.name());
    }

    public static List<ExprCoreType> coreTypes() {
        return Arrays.stream(ExprCoreType.values()).filter(type -> type != UNKNOWN).filter(type -> type != UNDEFINED).collect(Collectors.toList());
    }

    public static Set<ExprType> numberTypes() {
        return NUMBER_TYPES;
    }

    static {
        LEGACY_TYPE_NAME_MAPPING = new ImmutableMap.Builder().put((Object)STRUCT, (Object)"OBJECT").put((Object)ARRAY, (Object)"NESTED").put((Object)STRING, (Object)"KEYWORD").build();
        NUMBER_TYPES = new ImmutableSet.Builder().add((Object)BYTE).add((Object)SHORT).add((Object)INTEGER).add((Object)LONG).add((Object)FLOAT).add((Object)DOUBLE).build();
    }
}

