# Test ssl with key/cert passed in

try:
    import io
    import ssl
except ImportError:
    print("SKIP")
    raise SystemExit

# Only mbedTLS supports PKCS8 keys.
if not hasattr(ssl, "MBEDTLS_VERSION"):
    print("SKIP")
    raise SystemExit

# This particular key was generated with:
# $ openssl genrsa -out key.pem 512
# $ openssl rsa -in key.pem -outform DER -out key.der
keypkcs8 = b'0\x82\x01U\x02\x01\x000\r\x06\t*\x86H\x86\xf7\r\x01\x01\x01\x05\x00\x04\x82\x01?0\x82\x01;\x02\x01\x00\x02A\x00\xae\x07\xbb\xbf \x8eL\\ G\x91\x1b\xc45\x89\x96\x0c\xca\x94\xa5\xc2%F\x84z\xea\xb2Y\xdd\x943\x1a\xe0\x1e\xfe%\xd3\xbc\x85\xf0\x05\x8eI\xca\x83\x8b\x86\xfd\x15P,\xa9t8\xc2s\x11\x7fk*[[w\xdd\x02\x03\x01\x00\x01\x02@?\x02-\xc7\x95Q\xef\xf3\xaa\xfc>]\x7f<\xa3\x03\xe0\xbd\xb7\xf4\x0b\xc6\xd31D\x0f\x95cT\x06D9\xed\xf0X\xa6\x18\xb4\xe7\x96\x8f\x91\xd6\xd7\xbfR\\V\xfd\x0e{\xd3\xa4e\xb4M\x01\xbb\xdf\xf1\xf0\xbcEA\x02!\x00\xd5\xd7f\xcc\x84\xf5Y&\xa7]\x00\x91\xc9\x8e\xb0\xf37\x108D\x7f&!JJ\x836\x83\x9f\n\xf2\x0f\x02!\x00\xd0W\x0ec\xa6\x86C\xf7\x8d\xbe\xf0\xbc2\xe3)|\xbb\xd6\xbb;\xb2\xafG\x05S\x0f-\x14X\n3S\x02 A\xf5\xb20\xcd\xa6<<\x8f\rA\xda\xb68<^\x99\x12x\xb8\xb0\x1b\x9b\xd3%\x8e\xb9\xa6\xf9\xcc\xcf\x83\x02!\x00\xa8.\xee\xdd\xc0\xeb8h\xda\x13^\xb0\xfe\x7fd\xd9]\xa5m\xc66k\xcap`\xe9\xaaav\xe4\xdd#\x02!\x00\xd1\xd0\x93\xe7wZ\xe0p\xd0M\x07\x9e\x13\xa7\xa7\x12\x95\x1e\x13h0O\xc0\x18\x1fa\x10")\x9f&U'

# Valid key in PKCS8 format, invalid cert
try:
    ssl.wrap_socket(io.BytesIO(), key=keypkcs8, cert=b"!")
except ValueError as er:
    print(repr(er))
