# Rocket Project

"""
Rocket, a tool launcher for Docker-based security tools.
"""

import sys

from PySide6.QtGui import QIcon
from PySide6.QtWidgets import QApplication

from src.path_resolver import PathResolver
from src.views.app import App
from src.theme_manager import ThemeManager

if __name__ == '__main__':
    app = QApplication(sys.argv)
    app.setWindowIcon(QIcon(PathResolver.resource_path('resources/assets/rocket.svg')))
    theme_manager = ThemeManager()
    current_theme = theme_manager.get_current_theme()
    theme_manager.apply_theme(app, current_theme)
    window = App()
    window.show()
    sys.exit(app.exec())
