"""Remove knowledge base aka pasta base

Revision ID: cb25cf42bda7
Revises: abb7ed8c56b4
Create Date: 2021-11-18 17:58:12.182704+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'cb25cf42bda7'
down_revision = 'abb7ed8c56b4'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('knowledge_base')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('knowledge_base',
    sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
    sa.Column('vulnerability_template_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('faraday_kb_id', sa.TEXT(), autoincrement=False, nullable=False),
    sa.Column('reference_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('script_name', sa.TEXT(), autoincrement=False, nullable=False),
    sa.Column('external_identifier', sa.TEXT(), autoincrement=False, nullable=False),
    sa.Column('tool_name', sa.TEXT(), autoincrement=False, nullable=False),
    sa.Column('false_positive', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('verified', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['vulnerability_template_id'], ['vulnerability_template.id'], name='knowledge_base_vulnerability_template_id_fkey'),
    sa.PrimaryKeyConstraint('id', name='knowledge_base_pkey'),
    sa.UniqueConstraint('external_identifier', 'tool_name', 'reference_id', name='uix_externalidentifier_toolname_referenceid')
    )
    op.create_index('ix_knowledge_base_vulnerability_template_id', 'knowledge_base', ['vulnerability_template_id'], unique=False)
    # ### end Alembic commands ###
