# Generated by default/object.tt
package Paws::Route53Resolver::FirewallRule;
  use Moose;
  has Action => (is => 'ro', isa => 'Str');
  has BlockOverrideDnsType => (is => 'ro', isa => 'Str');
  has BlockOverrideDomain => (is => 'ro', isa => 'Str');
  has BlockOverrideTtl => (is => 'ro', isa => 'Int');
  has BlockResponse => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has CreatorRequestId => (is => 'ro', isa => 'Str');
  has FirewallDomainListId => (is => 'ro', isa => 'Str');
  has FirewallRuleGroupId => (is => 'ro', isa => 'Str');
  has ModificationTime => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has Priority => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Route53Resolver::FirewallRule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Route53Resolver::FirewallRule object:

  $service_obj->Method(Att1 => { Action => $value, ..., Priority => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Route53Resolver::FirewallRule object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

A single firewall rule in a rule group.

=head1 ATTRIBUTES


=head2 Action => Str

The action that DNS Firewall should take on a DNS query when it matches
one of the domains in the rule's domain list:

=over

=item *

C<ALLOW> - Permit the request to go through.

=item *

C<ALERT> - Permit the request to go through but send an alert to the
logs.

=item *

C<BLOCK> - Disallow the request. If this is specified, additional
handling details are provided in the rule's C<BlockResponse> setting.

=back



=head2 BlockOverrideDnsType => Str

The DNS record's type. This determines the format of the record value
that you provided in C<BlockOverrideDomain>. Used for the rule action
C<BLOCK> with a C<BlockResponse> setting of C<OVERRIDE>.


=head2 BlockOverrideDomain => Str

The custom DNS record to send back in response to the query. Used for
the rule action C<BLOCK> with a C<BlockResponse> setting of
C<OVERRIDE>.


=head2 BlockOverrideTtl => Int

The recommended amount of time, in seconds, for the DNS resolver or web
browser to cache the provided override record. Used for the rule action
C<BLOCK> with a C<BlockResponse> setting of C<OVERRIDE>.


=head2 BlockResponse => Str

The way that you want DNS Firewall to block the request. Used for the
rule action setting C<BLOCK>.

=over

=item *

C<NODATA> - Respond indicating that the query was successful, but no
response is available for it.

=item *

C<NXDOMAIN> - Respond indicating that the domain name that's in the
query doesn't exist.

=item *

C<OVERRIDE> - Provide a custom override in the response. This option
requires custom handling details in the rule's C<BlockOverride*>
settings.

=back



=head2 CreationTime => Str

The date and time that the rule was created, in Unix time format and
Coordinated Universal Time (UTC).


=head2 CreatorRequestId => Str

A unique string defined by you to identify the request. This allows you
to retry failed requests without the risk of executing the operation
twice. This can be any unique string, for example, a timestamp.


=head2 FirewallDomainListId => Str

The ID of the domain list that's used in the rule.


=head2 FirewallRuleGroupId => Str

The unique identifier of the firewall rule group of the rule.


=head2 ModificationTime => Str

The date and time that the rule was last modified, in Unix time format
and Coordinated Universal Time (UTC).


=head2 Name => Str

The name of the rule.


=head2 Priority => Int

The priority of the rule in the rule group. This value must be unique
within the rule group. DNS Firewall processes the rules in a rule group
by order of priority, starting from the lowest setting.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Route53Resolver>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

