## Terminal::ANSI

ANSI Escape Sequences

This module exports functions for emitting ANSI escape sequences.

It also maintains some state about the screen, such as a currently active scroll region.

It can optionally maintain the state of all of the characters on the screen, by writing to a virtual screen.

## Exported Functions

[atomically(&callable)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L222) Combine a series of outputs into one.

[bold()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L198) Bold (increased intensity)

[clear-screen()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L49) Clear the screen.

[cursor-down($amt = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L127) Move cursor down.

[cursor-left($amt = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L142) Move cursor left.

[cursor-off()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L117) Turn off cursor (civis).

[cursor-on()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L122) Turn on cursor (cnorm).

[cursor-right($amt = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L137) Move cursor right.

[cursor-up($amt = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L132) Move cursor up.

[disable-output()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L248) Suppress all output

[enable-output()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L254) Enable output

[enable-virtual()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L238) Send commands to a virtual screen

[erase-to-end-of-line()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L178) Erase to end of line.

[faint()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L203) Faint (lower intensity)

[hide-cursor()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L97) Hide the cursor.

[home()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L60) Move to home (0,0).

[move-to($l, $c = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L55) Move the cursor to line, column.

[normal-video()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L188) Normal video

[parse-input($str)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L259) Return a description of the given input sequence

[print-at($r, $c, $str)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L147) Atomic move + print.

[reset-scroll-region()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L72) Reset the scroll region.

[restore-cursor()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L168) restore the cursor position.

[restore-screen()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L112) Restore screen (rmcup).

[reverse-video()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L183) Reverse video

[save-cursor()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L163) Save the cursor position.

[save-screen()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L107) Save screen state (smcup).

[scroll-down($n = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L79) Scroll down by an amount.

[scroll-up($n = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L88) Scroll up by an amount.

[set-bg-color($n)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L158) Set bg color to $n.

[set-fg-color($n)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L153) Set fg color to $n.

[set-scroll-region($top, $bottom)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L65) Set scroll region to top, bottom.

[show-cursor()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L102) Show the cursor.

[start-of-line()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L173) Move to start of line.

[terminal-ansi-throttle($rate = 0.1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L216) Slow down the output for debugging

[text-reset()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L193) Text reset (same as normal-video)

[tget(&callable)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L208) Get strings instead of printing them.

[virtual-screen()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.13/lib/Terminal/ANSI.rakumod#L243) Get the virtual screen receiving commands
