# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package JobAd::GEN::AuthPages;

use strict;

use base 'JobAd';

use JobAd::Model::auth_pages qw(
    $AUTH_PAGES
);

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Auth Pages' );

    my $retval = {
        headings       => [
            'User Perm',
            'Group Perm',
        ],
        header_options => [
            {
                text => 'Add',
                link => $self->location() . "/add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $AUTH_PAGES->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->user_perm,
                    $row->group_perm,
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $self->location() . "/edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $self->location() . "/delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $AUTH_PAGES->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        fields     => [
            {
                name => 'user_perm',
                label => 'User Perm',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'group_perm',
                label => 'Group Perm',
                type => 'text',
                is => 'int4',
            },
            {
                name => 'world_perm',
                label => 'World Perm',
                type => 'text',
                is => 'int4',
            },
            {
                options => $selections->{auth_users},
                name => 'owner_id',
                label => 'Owner Id',
                type => 'text',
                is => 'int4',
            },
            {
                options => $selections->{auth_groups},
                name => 'group_id',
                label => 'Group Id',
                type => 'text',
                is => 'int4',
            },
            {
                name => 'url',
                label => 'Url',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'title',
                label => 'Title',
                type => 'text',
                is => 'varchar',
            },
        ],
    };
} # END form


1;

=head1 NAME

JobAd::GEN::AuthPages - generated support module for JobAd::AuthPages

=head1 SYNOPSIS

In JobAd::AuthPages:

    use JobAd::GEN::AuthPages qw(
        do_main
        form
    );

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in JobAd::AuthPages to provide the methods below.
They are exported by default.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

