/*
 * This file is part of ChronoJump
 *
 * ChronoJump is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or   
 *    (at your option) any later version.
 *    
 * ChronoJump is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Xavier de Blas: 
 * http://www.xdeblas.com, http://www.deporteyciencia.com (parleblas)
 */

using System;
using Gtk;
using Glade;
//using Gnome;
using GLib; //for Value
using System.Text; //StringBuilder
using System.Collections; //ArrayList
using Mono.Unix;

public class PreferencesWindow {
	
	[Widget] Gtk.Window preferences;
	[Widget] Gtk.Entry entry_chronopic;
	[Widget] Gtk.SpinButton spinbutton_decimals;
	[Widget] Gtk.CheckButton checkbutton_height;
	[Widget] Gtk.CheckButton checkbutton_initial_speed;
	[Widget] Gtk.CheckButton checkbutton_ask_deletion;
	[Widget] Gtk.CheckButton checkbutton_height_preferred;
	[Widget] Gtk.CheckButton checkbutton_meters_seconds_preferred;
	[Widget] Gtk.CheckButton checkbutton_percent_kg_preferred;
	[Widget] Gtk.Box hbox_language_row;
	[Widget] Gtk.Box hbox_combo_language;
	[Widget] Gtk.Combo combo_language;
	[Widget] Gtk.Separator hseparator_language;

	[Widget] Gtk.Button button_accept;
	
	static PreferencesWindow PreferencesWindowBox;
	Gtk.Window parent;

	//language when window is called. If changes, then chnge data in sql and show 
	//dialogMessage
	private string languageIni;
	
	private static string [] comboLanguageOptions = {
		"es-ES", 
		"en-GB", 
		"zh-CN", 
		"vi-VN", 
		"sv-SE", 
	};
	
		
	PreferencesWindow (Gtk.Window parent, string entryChronopic) {
		Glade.XML gladeXML;
		try {
			gladeXML = Glade.XML.FromAssembly ("chronojump.glade", "preferences", null);
		} catch {
			gladeXML = Glade.XML.FromAssembly ("chronojump.glade.chronojump.glade", "preferences", null);
		}

		gladeXML.Autoconnect(this);
		this.parent = parent;
		
		if(entryChronopic.Length > 0) {
			entry_chronopic.Text = entryChronopic;
		}
		
	}
	
	//static public PreferencesWindow Show (Gtk.Window parent, int digitsNumber, bool showHeight, bool showInitialSpeed, bool askDeletion, bool weightStatsPercent, bool heightPreferred, bool metersSecondsPreferred)
	static public PreferencesWindow Show (Gtk.Window parent, string entryChronopic, int digitsNumber, bool showHeight, bool showInitialSpeed, bool askDeletion, bool heightPreferred, bool metersSecondsPreferred, string culture)
	{
		if (PreferencesWindowBox == null) {
			PreferencesWindowBox = new PreferencesWindow (parent, entryChronopic);
		}


		PreferencesWindowBox.languageIni = culture;
		if(Util.IsWindows())
			PreferencesWindowBox.createComboLanguage(culture);
		else 
			PreferencesWindowBox.hideLanguageStuff();
		
		PreferencesWindowBox.spinbutton_decimals.Value = digitsNumber;
	
		if(showHeight) { 
			PreferencesWindowBox.checkbutton_height.Active = true; 
		}
		else {
			PreferencesWindowBox.checkbutton_height.Active = false; 
		}

		if(showInitialSpeed) { 
			PreferencesWindowBox.checkbutton_initial_speed.Active = true; 
		}
		else {
			PreferencesWindowBox.checkbutton_initial_speed.Active = false; 
		}

		if(askDeletion) { 
			PreferencesWindowBox.checkbutton_ask_deletion.Active = true; 
		}
		else {
			PreferencesWindowBox.checkbutton_ask_deletion.Active = false; 
		}

		/*
		if(weightStatsPercent) { 
			PreferencesWindowBox.checkbutton_percent_kg_preferred.Active = true; 
		}
		else {
			PreferencesWindowBox.checkbutton_percent_kg_preferred.Active = false; 
		}
		*/

		if(heightPreferred) { 
			PreferencesWindowBox.checkbutton_height_preferred.Active = true; 
		}
		else {
			PreferencesWindowBox.checkbutton_height_preferred.Active = false; 
		}

		if(metersSecondsPreferred) { 
			PreferencesWindowBox.checkbutton_meters_seconds_preferred.Active = true; 
		}
		else {
			PreferencesWindowBox.checkbutton_meters_seconds_preferred.Active = false; 
		}

		PreferencesWindowBox.preferences.Show ();

		return PreferencesWindowBox;
	}
	
	private void createComboLanguage(string myLanguage) {
		combo_language = new Combo ();
		combo_language.PopdownStrings = comboLanguageOptions;
		
		//combo_language.Entry.Changed += new EventHandler (on_combo_language_changed);

		hbox_combo_language.PackStart(combo_language, false, false, 0);
		hbox_combo_language.ShowAll();
		
		bool found = false;
		foreach (string lang in comboLanguageOptions) {
			if (myLanguage == lang) {
				combo_language.Entry.Text = lang;
				found = true;
			}
		}
		if(!found)
			combo_language.Entry.Text = "en-GB";

		
		//if(Util.IsWindows())
			combo_language.Sensitive = true;
		//else 
		//	combo_language.Sensitive = false;
	}
			
	private void hideLanguageStuff() {
		hbox_language_row.Hide();
		hseparator_language.Hide();
	}
	
	void on_button_cancel_clicked (object o, EventArgs args)
	{
		PreferencesWindowBox.preferences.Hide();
		PreferencesWindowBox = null;
	}
	
	void on_preferences_delete_event (object o, DeleteEventArgs args)
	{
		PreferencesWindowBox.preferences.Hide();
		PreferencesWindowBox = null;
	}
	
	void on_button_accept_clicked (object o, EventArgs args)
	{
		SqlitePreferences.Update("chronopicPort", entry_chronopic.Text.ToString());
		SqlitePreferences.Update("digitsNumber", spinbutton_decimals.Value.ToString());
		SqlitePreferences.Update("showHeight", PreferencesWindowBox.checkbutton_height.Active.ToString());
		SqlitePreferences.Update("showInitialSpeed", PreferencesWindowBox.checkbutton_initial_speed.Active.ToString());
		SqlitePreferences.Update("askDeletion", PreferencesWindowBox.checkbutton_ask_deletion.Active.ToString());
		//SqlitePreferences.Update("weightStatsPercent", PreferencesWindowBox.checkbutton_percent_kg_preferred.Active.ToString());
		SqlitePreferences.Update("heightPreferred", PreferencesWindowBox.checkbutton_height_preferred.Active.ToString());
		SqlitePreferences.Update("metersSecondsPreferred", PreferencesWindowBox.checkbutton_meters_seconds_preferred.Active.ToString());
		
		if(Util.IsWindows()) {
			//if language has changed
			if(PreferencesWindowBox.combo_language.Entry.Text != languageIni) {
				string myLanguage = SqlitePreferences.Select("language");
				if ( myLanguage != null && myLanguage != "" && myLanguage != "0") {
					//if language exists in sqlite preferences update it
					SqlitePreferences.Update("language", PreferencesWindowBox.combo_language.Entry.Text);
				} else {
					//else: create it
					SqlitePreferences.Insert("language", PreferencesWindowBox.combo_language.Entry.Text);
				}

				new DialogMessage(Catalog.GetString("Restart Chronojump to operate completely on your language."));
			}
		}

		PreferencesWindowBox.preferences.Hide();
		PreferencesWindowBox = null;
	}

	private void on_button_help_clicked (object o, EventArgs args) {
		new HelpPorts();
	}

	public Button Button_accept 
	{
		set {
			button_accept = value;	
		}
		get {
			return button_accept;
		}
	}

}
