/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.emf;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.emf.EMFResourceException;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class ResourceManager {
    private ResourceManager() {
    }

    public static <T> T loadObject(String resourcePath, Class<T> objClass) throws EMFResourceException {
        URI resourceUri = Paths.createEmfURI((String)resourcePath);
        return ResourceManager.loadObject(resourceUri, objClass);
    }

    public static <T> T loadObject(URI resourceUri, Class<T> objClass) throws EMFResourceException {
        Resource res = ResourceManager.loadResource(resourceUri, true);
        EObject root = (EObject)res.getContents().get(0);
        if (!objClass.isInstance(root)) {
            throw new EMFResourceException(Strings.fmt((String)"Could not load resource \"%s\", since it contains a root object of type \"%s\", while a root object of type \"%s\" was expected.", (Object[])new Object[]{resourceUri, root.getClass().getSimpleName(), objClass.getSimpleName()}));
        }
        return (T)root;
    }

    public static Resource loadResource(String resourcePath) throws EMFResourceException {
        return ResourceManager.loadResource(resourcePath, false);
    }

    public static Resource loadResource(URI resourceUri) throws EMFResourceException {
        return ResourceManager.loadResource(resourceUri, false);
    }

    public static Resource loadResource(String resourcePath, boolean requireSingleRoot) throws EMFResourceException {
        URI resourceUri = Paths.createEmfURI((String)resourcePath);
        return ResourceManager.loadResource(resourceUri, requireSingleRoot);
    }

    public static Resource loadResource(URI resourceUri, boolean requireSingleRoot) throws EMFResourceException {
        Resource resource;
        OutputProvider.dbg((String)("Loading resource from: " + String.valueOf(resourceUri)));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (!URIConverter.INSTANCE.exists(resourceUri, null)) {
            String msg = Strings.fmt((String)"Could not find \"%s\".", (Object[])new Object[]{resourceUri});
            throw new EMFResourceException(msg);
        }
        try {
            resource = resourceSet.getResource(resourceUri, true);
        }
        catch (WrappedException e) {
            String msg = Strings.fmt((String)"Failed to load resource \"%s\".", (Object[])new Object[]{resourceUri});
            throw new EMFResourceException(msg, e);
        }
        catch (RuntimeException e) {
            String msg = Strings.fmt((String)"Cannot load resource \"%s\". Make sure the file has the proper file extension.", (Object[])new Object[]{resourceUri});
            throw new EMFResourceException(msg, e);
        }
        EcoreUtil.resolveAll((Resource)resource);
        Diagnostician diagnostician = new Diagnostician();
        List diagnostics = Lists.list();
        for (EObject obj : resource.getContents()) {
            Diagnostic diagnostic = diagnostician.validate(obj);
            diagnostics.add(diagnostic);
        }
        try {
            EMFHelper.checkResourceWarningsErrors(resource, diagnostics, false);
        }
        catch (EMFResourceException e) {
            throw new EMFResourceException(Strings.fmt((String)"The resource loaded from \"%s\" has errors.", (Object[])new Object[]{resourceUri}), e);
        }
        EList contents = resource.getContents();
        if (contents.size() != 1) {
            if (requireSingleRoot) {
                throw new EMFResourceException(Strings.fmt((String)"Failed to load resource \"%s\", as it contains %d root objects, while a single root object is expected.", (Object[])new Object[]{resourceUri, contents.size()}));
            }
            OutputProvider.warn((String)"Loaded resource \"%s\" does not contain exactly one root element.", (Object[])new Object[]{resourceUri});
        }
        return resource;
    }

    public static void saveResource(Resource resource, String resourcePath) throws EMFResourceException {
        URI resourceUri = Paths.createEmfURI((String)resourcePath);
        ResourceManager.saveResource(resource, resourceUri);
    }

    public static void saveResource(Resource resource, URI resourceUri) throws EMFResourceException {
        OutputProvider.dbg((String)("Saving resource to: " + String.valueOf(resourceUri)));
        Resource res = EMFHelper.copyResource(resource, resourceUri, true);
        EList contents = resource.getContents();
        if (contents.size() != 1) {
            OutputProvider.warn((String)"Saving resource with %d root elements.", (Object[])new Object[]{contents.size()});
        }
        try {
            res.save(null);
        }
        catch (IOException e) {
            throw new EMFResourceException("Error saving resource to: " + String.valueOf(resourceUri), e);
        }
    }

    public static void saveResource(EObject obj, String resourcePath) throws EMFResourceException {
        URI resourceUri = Paths.createEmfURI((String)resourcePath);
        ResourceManager.saveResource(obj, resourceUri);
    }

    public static void saveResource(EObject obj, URI resourceUri) throws EMFResourceException {
        OutputProvider.dbg((String)("Saving resource to: " + String.valueOf(resourceUri)));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource res = resourceSet.createResource(resourceUri);
        res.getContents().add((Object)obj);
        try {
            res.save(null);
        }
        catch (IOException e) {
            throw new EMFResourceException("Error saving resource to: " + String.valueOf(resourceUri), e);
        }
    }
}

