/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.frames;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http2.HeadersEncoder;

public final class CompressedHeadersBuilder {
    private final Map<String, String> headers = new HashMap<String, String>();

    private CompressedHeadersBuilder() {
    }

    public static CompressedHeadersBuilder newInstance() {
        return new CompressedHeadersBuilder();
    }

    public CompressedHeadersBuilder contentLength(long contentLength) {
        return this.header(Header.ContentLength, String.valueOf(contentLength));
    }

    public CompressedHeadersBuilder contentType(String contentType) {
        return this.header(Header.ContentType, String.valueOf(contentType));
    }

    public CompressedHeadersBuilder method(Method method) {
        return this.method(method.getMethodString());
    }

    public CompressedHeadersBuilder method(String method) {
        return this.header(":method", method);
    }

    public CompressedHeadersBuilder path(String path) {
        return this.header(":path", path);
    }

    public CompressedHeadersBuilder version(Protocol version) {
        return this.version(version.getProtocolString());
    }

    public CompressedHeadersBuilder version(String version) {
        return this.header(":version", version);
    }

    public CompressedHeadersBuilder host(String host) {
        return this.header(":host", host);
    }

    public CompressedHeadersBuilder scheme(String scheme) {
        return this.header(":scheme", scheme);
    }

    public CompressedHeadersBuilder status(int status) {
        return this.status(String.valueOf(status));
    }

    public CompressedHeadersBuilder status(HttpStatus status) {
        StringBuilder sb = new StringBuilder();
        sb.append(status.getStatusCode()).append(' ').append(new String(status.getReasonPhraseBytes(), Constants.DEFAULT_HTTP_CHARSET));
        return this.status(sb.toString());
    }

    public CompressedHeadersBuilder status(String status) {
        return this.header(":status", status);
    }

    public CompressedHeadersBuilder header(String name, String value) {
        this.headers.put(name.toLowerCase(Locale.US), value);
        return this;
    }

    public CompressedHeadersBuilder header(Header header, String value) {
        this.headers.put(header.getLowerCase(), value);
        return this;
    }

    public Buffer build(HeadersEncoder encoder) throws IOException {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            encoder.encodeHeader(entry.getKey(), entry.getValue(), null);
        }
        return encoder.flushHeaders();
    }
}

