/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.shell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;

public class Procedural {
    static final String[] functions = new String[]{"each", "if", "not", "throw", "try", "until", "while"};

    public List<Object> each(CommandSession session, Collection<Object> list, Function closure) throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList<Object> results = new ArrayList<Object>();
        args.add(null);
        for (Object x : list) {
            this.checkInterrupt();
            args.set(0, x);
            results.add(closure.execute(session, args));
        }
        return results;
    }

    public Object _if(CommandSession session, Function[] fns) throws Exception {
        int length = fns.length;
        if (length < 2) {
            throw new IllegalArgumentException("Usage: if {condition} {if-action} ... {else-action}");
        }
        for (int i = 0; i < length; ++i) {
            if (i != length - 1 && !this.isTrue(fns[i++].execute(session, null))) continue;
            return fns[i].execute(session, null);
        }
        return null;
    }

    public boolean not(CommandSession session, Function condition) throws Exception {
        if (null == condition) {
            return true;
        }
        return !this.isTrue(condition.execute(session, null));
    }

    public void _throw(String message) {
        throw new IllegalArgumentException(message);
    }

    public void _throw(Exception e) throws Exception {
        throw e;
    }

    public void _throw(CommandSession session) throws Throwable {
        Object exception = session.get("exception");
        if (exception instanceof Throwable) {
            throw (Throwable)exception;
        }
        throw new IllegalArgumentException("exception not set or not Throwable.");
    }

    public Object _try(CommandSession session, Function func) {
        try {
            return func.execute(session, null);
        }
        catch (Exception e) {
            session.put("exception", (Object)e);
            return null;
        }
    }

    public Object _try(CommandSession session, Function func, Function error) throws Exception {
        try {
            return func.execute(session, null);
        }
        catch (Exception e) {
            session.put("exception", (Object)e);
            return error.execute(session, null);
        }
    }

    public void _while(CommandSession session, Function condition, Function ifTrue) throws Exception {
        while (this.isTrue(condition.execute(session, null))) {
            ifTrue.execute(session, null);
        }
    }

    public void until(CommandSession session, Function condition, Function ifTrue) throws Exception {
        while (!this.isTrue(condition.execute(session, null))) {
            ifTrue.execute(session, null);
        }
    }

    private boolean isTrue(Object result) throws InterruptedException {
        this.checkInterrupt();
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof Number && 0 == ((Number)result).intValue()) {
            return false;
        }
        if ("".equals(result)) {
            return false;
        }
        return !"0".equals(result);
    }

    private void checkInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("loop interrupted");
        }
    }
}

