/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.FacesLogger;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.NavigationHandler;
import jakarta.faces.component.ActionSource2;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActionListenerImpl
implements ActionListener {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    @Override
    public void processAction(ActionEvent event) {
        LOGGER.log(Level.FINE, () -> MessageFormat.format("processAction({0})", event.getComponent().getId()));
        UIComponent source = event.getComponent();
        FacesContext context = event.getFacesContext();
        MethodExpression expression = ((ActionSource2)((Object)source)).getActionExpression();
        this.invokeNavigationHandling(context, source, expression, this.getNavigationOutcome(context, expression));
        context.renderResponse();
    }

    private String getNavigationOutcome(FacesContext context, MethodExpression expression) {
        if (expression == null) {
            return null;
        }
        try {
            Object invokeResult = expression.invoke(context.getELContext(), null);
            if (invokeResult == null) {
                return null;
            }
            return invokeResult.toString();
        }
        catch (ELException | NullPointerException e) {
            LOGGER.log(Level.FINE, e, () -> ActionListenerImpl.lambda$getNavigationOutcome$1((RuntimeException)e));
            throw new FacesException(expression.getExpressionString() + ": " + e.getMessage(), e);
        }
    }

    private void invokeNavigationHandling(FacesContext context, UIComponent source, MethodExpression expression, String outcome) {
        NavigationHandler navHandler = context.getApplication().getNavigationHandler();
        String toFlowDocumentId = (String)source.getAttributes().get("to-flow-document-id");
        if (toFlowDocumentId == null) {
            navHandler.handleNavigation(context, expression != null ? expression.getExpressionString() : null, outcome);
        } else {
            navHandler.handleNavigation(context, expression != null ? expression.getExpressionString() : null, outcome, toFlowDocumentId);
        }
    }

    private static /* synthetic */ String lambda$getNavigationOutcome$1(RuntimeException e) {
        return e.getMessage();
    }
}

