/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.IconHyperlink;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;

public final class Alert
extends UIOutput
implements NamingContainer {
    public static final String ALERT_IMAGE_FACET = "alertImage";
    public static final String ALERT_LINK_FACET = "alertLink";
    private String alt = null;
    private String detail = null;
    private MethodExpression linkActionExpression = null;
    private String linkTarget = null;
    private String linkText = null;
    private String linkToolTip = null;
    private String linkURL = null;
    private String style = null;
    private String styleClass = null;
    private String summary = null;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndexSet = false;
    private String type = null;
    private boolean visible = false;
    private boolean visibleSet = false;

    public Alert() {
        this.setRendererType("com.sun.webui.jsf.Alert");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Alert";
    }

    public UIComponent getAlertIcon() {
        UIComponent imageFacet = this.getFacet(ALERT_IMAGE_FACET);
        if (imageFacet != null) {
            return imageFacet;
        }
        Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
        String iconidentifier = this.getIconIdentifier();
        Icon icon = ThemeUtilities.getIcon(theme, iconidentifier);
        icon.setId(ALERT_IMAGE_FACET);
        icon.setParent((UIComponent)this);
        String iconalt = this.getAlt();
        if (iconalt != null) {
            icon.setAlt(iconalt);
        }
        return icon;
    }

    public UIComponent getAlertLink() {
        UIComponent linkFacet = this.getFacet(ALERT_LINK_FACET);
        if (linkFacet != null) {
            return linkFacet;
        }
        IconHyperlink h = (IconHyperlink)ComponentUtilities.getPrivateFacet((UIComponent)this, ALERT_LINK_FACET, false);
        String linktext = this.getLinkText();
        if (linktext == null) {
            if (h != null) {
                ComponentUtilities.removePrivateFacet((UIComponent)this, ALERT_LINK_FACET);
            }
            return null;
        }
        if (h == null) {
            h = new IconHyperlink();
            h.setId(ALERT_LINK_FACET);
            ComponentUtilities.putPrivateFacet((UIComponent)this, ALERT_LINK_FACET, (UIComponent)h);
        }
        h.setIcon("HREF_LINK");
        h.setTarget(this.getLinkTarget());
        h.setText(linktext);
        h.setToolTip(this.getLinkToolTip());
        h.setUrl(this.getLinkURL());
        MethodExpression action = this.getLinkActionExpression();
        if (action != null) {
            h.setActionExpression(action);
        }
        return h;
    }

    private String getIconIdentifier() {
        String alertType = this.getType();
        if (alertType != null) {
            String lower = alertType.toLowerCase();
            if (lower.startsWith("warn")) {
                return "ALERT_WARNING_LARGE";
            }
            if (lower.startsWith("ques")) {
                return "ALERT_HELP_LARGE";
            }
            if (lower.startsWith("info")) {
                return "ALERT_INFO_LARGE";
            }
            if (lower.startsWith("succ")) {
                return "ALERT_SUCCESS_LARGE";
            }
        }
        return "ALERT_ERROR_LARGE";
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public Converter getConverter() {
        return super.getConverter();
    }

    public Object getValue() {
        return super.getValue();
    }

    public String getAlt() {
        if (this.alt != null) {
            return this.alt;
        }
        ValueExpression vb = this.getValueExpression("alt");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAlt(String newAlt) {
        this.alt = newAlt;
    }

    public String getDetail() {
        if (this.detail != null) {
            return this.detail;
        }
        ValueExpression vb = this.getValueExpression("detail");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setDetail(String newDetails) {
        this.detail = newDetails;
    }

    public MethodExpression getLinkActionExpression() {
        if (this.linkActionExpression != null) {
            return this.linkActionExpression;
        }
        ValueExpression vb = this.getValueExpression("linkActionExpression");
        if (vb != null) {
            return (MethodExpression)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setLinkActionExpression(MethodExpression newLinkActionExpression) {
        this.linkActionExpression = newLinkActionExpression;
    }

    public String getLinkTarget() {
        if (this.linkTarget != null) {
            return this.linkTarget;
        }
        ValueExpression vb = this.getValueExpression("linkTarget");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setLinkTarget(String newLinkTarget) {
        this.linkTarget = newLinkTarget;
    }

    public String getLinkText() {
        if (this.linkText != null) {
            return this.linkText;
        }
        ValueExpression vb = this.getValueExpression("linkText");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setLinkText(String newLinkText) {
        this.linkText = newLinkText;
    }

    public String getLinkToolTip() {
        if (this.linkToolTip != null) {
            return this.linkToolTip;
        }
        ValueExpression vb = this.getValueExpression("linkToolTip");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setLinkToolTip(String newLinkToolTip) {
        this.linkToolTip = newLinkToolTip;
    }

    public String getLinkURL() {
        if (this.linkURL != null) {
            return this.linkURL;
        }
        ValueExpression vb = this.getValueExpression("linkURL");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setLinkURL(String newLinkURL) {
        this.linkURL = newLinkURL;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public String getSummary() {
        if (this.summary != null) {
            return this.summary;
        }
        ValueExpression vb = this.getValueExpression("summary");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSummary(String newSummary) {
        this.summary = newSummary;
    }

    public int getTabIndex() {
        if (this.tabIndexSet) {
            return this.tabIndex;
        }
        ValueExpression vb = this.getValueExpression("tabIndex");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int newTabIndex) {
        this.tabIndex = newTabIndex;
        this.tabIndexSet = true;
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        ValueExpression vb = this.getValueExpression("type");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.alt = (String)values[1];
        this.detail = (String)values[2];
        this.linkActionExpression = (MethodExpression)Alert.restoreAttachedState((FacesContext)context, (Object)values[3]);
        this.linkTarget = (String)values[4];
        this.linkText = (String)values[5];
        this.linkToolTip = (String)values[6];
        this.linkURL = (String)values[7];
        this.style = (String)values[8];
        this.styleClass = (String)values[9];
        this.summary = (String)values[10];
        this.tabIndex = (Integer)values[11];
        this.tabIndexSet = (Boolean)values[12];
        this.type = (String)values[13];
        this.visible = (Boolean)values[14];
        this.visibleSet = (Boolean)values[15];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.alt, this.detail, Alert.saveAttachedState((FacesContext)context, (Object)this.linkActionExpression), this.linkTarget, this.linkText, this.linkToolTip, this.linkURL, this.style, this.styleClass, this.summary, this.tabIndex, this.tabIndexSet ? Boolean.TRUE : Boolean.FALSE, this.type, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }
}

