/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.ConcurrencyGroupElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceMemberElement;
import java.util.ArrayList;

public class PersistenceFieldElement
extends PersistenceMemberElement {
    public static final int PERSISTENT = 0;
    public static final int DERIVED = 1;
    public static final int TRANSIENT = 2;

    public PersistenceFieldElement() {
        this(null, null);
    }

    public PersistenceFieldElement(Impl impl, PersistenceClassElement declaringClass) {
        super(impl, declaringClass);
    }

    final Impl getFieldImpl() {
        return (Impl)this.getImpl();
    }

    public int getPersistenceType() {
        return this.getFieldImpl().getPersistenceType();
    }

    public void setPersistenceType(int type) throws ModelException {
        this.getFieldImpl().setPersistenceType(type);
    }

    public boolean isReadSensitive() {
        return this.getPersistenceType() == 1 && this.getFieldImpl().isReadSensitive();
    }

    public void setReadSensitive(boolean flag) throws ModelException {
        this.getFieldImpl().setReadSensitive(flag);
    }

    public boolean isWriteSensitive() {
        return this.getPersistenceType() == 1 && this.getFieldImpl().isWriteSensitive();
    }

    public void setWriteSensitive(boolean flag) throws ModelException {
        this.getFieldImpl().setWriteSensitive(flag);
    }

    public boolean isKey() {
        return this.getFieldImpl().isKey();
    }

    public void setKey(boolean flag) throws ModelException {
        this.getFieldImpl().setKey(flag);
    }

    public ConcurrencyGroupElement[] getConcurrencyGroups() {
        ConcurrencyGroupElement[] groups = this.getDeclaringClass().getConcurrencyGroups();
        int count = groups != null ? groups.length : 0;
        ArrayList<ConcurrencyGroupElement> myGroups = new ArrayList<ConcurrencyGroupElement>(count);
        for (int i = 0; i < count; ++i) {
            ConcurrencyGroupElement group = groups[i];
            if (!group.containsField(this)) continue;
            myGroups.add(group);
        }
        count = myGroups.size();
        return myGroups.toArray(new ConcurrencyGroupElement[count]);
    }

    public int getFieldNumber() {
        PersistenceFieldElement[] fields = this.getDeclaringClass().getFields();
        int count = fields != null ? fields.length : 0;
        for (int i = 0; i < count; ++i) {
            if (!this.equals(fields[i])) continue;
            return i;
        }
        return -1;
    }

    public static interface Impl
    extends PersistenceMemberElement.Impl {
        public int getPersistenceType();

        public void setPersistenceType(int var1) throws ModelException;

        public boolean isReadSensitive();

        public void setReadSensitive(boolean var1) throws ModelException;

        public boolean isWriteSensitive();

        public void setWriteSensitive(boolean var1) throws ModelException;

        public boolean isKey();

        public void setKey(boolean var1) throws ModelException;
    }
}

